package com.xforceplus.seller.invoice.client.model;

import java.util.stream.Stream;

/**
 * 作废发票、红冲发票回写释放
 */
public enum IssueWriteBackMethodEnum {

    /**
     * 作废红冲票、红冲发票、作废蓝票、作废红票 来源及其对应【红冲票】均为 直连开票
     */
    DIRECT("0","direct"),

    /**
     * 作废红冲票/红冲发票 其对应蓝票来源为 抽取票
     */
    ORIGIN_INVOICE_IS_DRAW_OUT("1","originInvoiceIsDrawOut"),

    /**
     * 作废蓝票、作废红票 其本身为 抽取票
     */
    INVOICE_IS_DRAW_OUT("2","invoiceIsDrawOut"),

    /**
     * 作废蓝票、作废红票 其本身为 已经关联了不开票单据
     */
    INVOICE_MATCHED_NOT_USING_BILL("3","invoiceMatchedNotUsingBill");

    private final String code;

    private final String description;

    IssueWriteBackMethodEnum(String code, String desc)
    {
        this.code = code;
        this.description = desc;
    }

    public String value()
    {
        return  this.code;
    }

    public String description(){return this.description;}

    public static String getIssueWriteBackMethodBy(String value) {
        return Stream.of(IssueWriteBackMethodEnum.values())
                .filter(r -> r.value().equals(value))
                .map(IssueWriteBackMethodEnum::description)
                .findFirst().orElse(null);
    }

    public static IssueWriteBackMethodEnum from(String value){
       return Stream.of(IssueWriteBackMethodEnum.values())
               .filter(r -> r.value().equals(value))
               .findFirst().orElse(null);
    }
}
