package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.seller.invoice.client.model.LockInvoiceCheckInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "外部锁定更新结果接口")

@JsonInclude(NON_NULL)
public class LockInvoiceByCodeResult {


    @ApiModelProperty(value = "外部锁定失败的发票id列表")
    private List<LockInvoiceCheckInfo> failedInvoiceInfos ;


    @ApiModelProperty(value = "外部锁定成功的发票id列表")
    private List<LockInvoiceCheckInfo> successInvoiceInfos ;

    public List<LockInvoiceCheckInfo> getFailedInvoiceInfos() {
        return failedInvoiceInfos;
    }

    public void setFailedInvoiceInfos(List<LockInvoiceCheckInfo> failedInvoiceInfos) {
        this.failedInvoiceInfos = failedInvoiceInfos;
    }

    public List<LockInvoiceCheckInfo> getSuccessInvoiceInfos() {
        return successInvoiceInfos;
    }

    public void setSuccessInvoiceInfos(List<LockInvoiceCheckInfo> successInvoiceInfos) {
        this.successInvoiceInfos = successInvoiceInfos;
    }






}
