package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "修改发票匹配的业务单号")
@JsonInclude(NON_NULL)
@Data
public class ModifyInvoiceBySalesRequest {

    @JsonProperty("salesbillId")
    private String salesbillId;//业务单id
    @JsonProperty("salesbillNo")
    private String salesbillNo;//业务单编号
    @JsonProperty("matchStatus")
    private String matchStatus;//1-已匹配，非1-取消匹配
    @JsonProperty("invoiceIds")
    private List<Long> invoiceIds;//发票集合
    @JsonProperty("systemOrig")
    private String systemOrig;//业务单来源

    private List<ModifyInvoiceBySalesRequest> bizorderInfos;// 业务单 Id 集合 ，多个业务单，对一个发票场景

    /**
     * 非原单单据和发票匹配时，用于传递记录原单和发票关系；原单与发票匹配是无用
     */
    private List<OriginRelation> originBizorderToInvoiceRelationList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class OriginRelation implements Serializable {
        private String salesbillId;
        private String salesbillNo;
    }

}
