package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 响应对象
 */
@ApiModel(description = "响应对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetInvoiceRedNoByBillResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("result")
  private MsGetRedNoListByInvoiceResponseResult result = null;

  @JsonIgnore
  public MsGetInvoiceRedNoByBillResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillResponse pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * return pageno
   * @return pageNo
  **/
  @ApiModelProperty(value = "return pageno")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillResponse pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * return pagesize
   * @return pageSize
  **/
  @ApiModelProperty(value = "return pagesize")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillResponse result(MsGetRedNoListByInvoiceResponseResult result) {
    this.result = result;
    return this;
  }

   /**
   * Get result
   * @return result
  **/
  @ApiModelProperty(value = "")
  public MsGetRedNoListByInvoiceResponseResult getResult() {
    return result;
  }

  public void setResult(MsGetRedNoListByInvoiceResponseResult result) {
    this.result = result;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetInvoiceRedNoByBillResponse getInvoiceRedNoByBillResponse = (MsGetInvoiceRedNoByBillResponse) o;
    return Objects.equals(this.code, getInvoiceRedNoByBillResponse.code) &&
        Objects.equals(this.message, getInvoiceRedNoByBillResponse.message) &&
        Objects.equals(this.pageNo, getInvoiceRedNoByBillResponse.pageNo) &&
        Objects.equals(this.pageSize, getInvoiceRedNoByBillResponse.pageSize) &&
        Objects.equals(this.result, getInvoiceRedNoByBillResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, pageNo, pageSize, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetInvoiceRedNoByBillResponse {\n");

    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
