package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.util.Date;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class MsQueryInvoiceResponse {

	/**
	 * 发票ID
	 */
	@JsonProperty("id")
	private Long id;

	/**
	 * 发票代码
	 */
	@JsonProperty("invoiceCode")
	private String invoiceCode;

	/**
	 * 发票号码
	 */
	@JsonProperty("invoiceNo")
	private String invoiceNo;

	/**
	 * 发票类型
     */
	@JsonProperty("invoiceType")
	private String invoiceType;

	/**
	 * 老发票类型
	 */
	@JsonProperty("invoiceKind")
	private String invoiceKind;
	/**
	 * 发票开票日期
	 */
	@JsonProperty("paperDrawDate")
	private Date paperDrawDate;

	/**
	 * 不含税金额
	 */
	@JsonProperty("amountWithoutTax")
	private BigDecimal amountWithoutTax;

	/**
	 * 含税金额
	 */
	@JsonProperty("amountWithTax")
	private BigDecimal amountWithTax;

	/**
	 * 税额
	 */
	@JsonProperty("taxAmount")
	private BigDecimal taxAmount;

	/**
	 * 购方纳税人识别号
	 */
	@JsonProperty("purchaserTaxNo")
	private String purchaserTaxNo;

	/**
	 * 销方纳税人识别号
	 */
	@JsonProperty("sellerTaxNo")
	private String sellerTaxNo;

	/**
	 * 机器编码
	 */
	@JsonProperty("machineCode")
	private String machineCode;

	/**
	 * 校验码
	 */
	@JsonProperty("checkCode")
	private String checkCode;

	/**
	 * 密文
	 */
	@JsonProperty("cipherText")
	private String cipherText;

	/**
	 * 红冲状态 0-默认 1-待红冲 2-待部分红冲3-红冲4-部分红冲
	 */
	@JsonProperty("redFlag")
	private String redFlag;

	/**
	 * 发票状态1-正常 0-作废 2-待处理
	 */
	@JsonProperty("status")
	private int status;

	/**
	 * 处理状态 1-正常 2-处理中
	 */
	@JsonProperty("handleStatus")
	private String handleStatus;

	/**
	 * 锁定状态1-已锁定 0-未锁定
	 */
	@JsonProperty("lockFlag")
	private String lockFlag;

	/**
	 * 认证状态 0-默认 1-不可认证 2-未认证 3-认证中 4-认证成功 5-认证失败 6-认证异常 7-已转出
	 */
	@JsonProperty("identifyStatus")
	private String identifyStatus;

	/**
	 * 打印状态1-已打印 0-未打印
	 */
	@JsonProperty("printStatus")
	private String printStatus;

	/**
	 * 退票状态 0-未退(默认) 1-已退
	 */
	@JsonProperty("retreatStatus")
	private String retreatStatus;

	/**
	 * 付款状态 0-未付款(默认) 1-部分付款 2-已付款
	 */
	@JsonProperty("paymentStatus")
	private String paymentStatus;

	/**
	 * 扩展字段ext17
	 */
	@JsonProperty("ext17")
	private String ext17;

	@JsonProperty("salesbillId")
	private String salesbillId;

	@JsonProperty("salesbillNo")
	private String salesbillNo;

	@JsonProperty("invoiceOrigin")
	private String invoiceOrigin;

	@JsonProperty("originInvoiceNo")
	private String originInvoiceNo;

	@JsonProperty("originInvoiceCode")
	private String originInvoiceCode ;

	@JsonProperty("invoiceColor")
	private String invoiceColor;

	@JsonProperty("businessBillType")
	private String businessBillType;

	@JsonProperty("sellerGroupId")
	private Long sellerGroupId;

	@JsonProperty("sellerName")
	private String sellerName;

	@JsonProperty("sellerNo")
	private String sellerNo;

	@JsonProperty("purchaserGroupId")
	private Long purchaserGroupId;

	@JsonProperty("purchaserName")
	private String purchaserName;

	@JsonProperty("purchaserNo")
	private String purchaserNo;

	@JsonProperty("billType")
	private String billType;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getInvoiceCode() {
		return invoiceCode;
	}

	public void setInvoiceCode(String invoiceCode) {
		this.invoiceCode = invoiceCode;
	}

	public String getInvoiceNo() {
		return invoiceNo;
	}

	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public Date getPaperDrawDate() {
		return paperDrawDate;
	}

	public void setPaperDrawDate(Date paperDrawDate) {
		this.paperDrawDate = paperDrawDate;
	}

	public BigDecimal getAmountWithoutTax() {
		return amountWithoutTax;
	}

	public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
		this.amountWithoutTax = amountWithoutTax;
	}

	public BigDecimal getAmountWithTax() {
		return amountWithTax;
	}

	public void setAmountWithTax(BigDecimal amountWithTax) {
		this.amountWithTax = amountWithTax;
	}

	public BigDecimal getTaxAmount() {
		return taxAmount;
	}

	public void setTaxAmount(BigDecimal taxAmount) {
		this.taxAmount = taxAmount;
	}

	public String getPurchaserTaxNo() {
		return purchaserTaxNo;
	}

	public void setPurchaserTaxNo(String purchaserTaxNo) {
		this.purchaserTaxNo = purchaserTaxNo;
	}

	public String getSellerTaxNo() {
		return sellerTaxNo;
	}

	public void setSellerTaxNo(String sellerTaxNo) {
		this.sellerTaxNo = sellerTaxNo;
	}

	public String getMachineCode() {
		return machineCode;
	}

	public void setMachineCode(String machineCode) {
		this.machineCode = machineCode;
	}

	public String getCheckCode() {
		return checkCode;
	}

	public void setCheckCode(String checkCode) {
		this.checkCode = checkCode;
	}

	public String getCipherText() {
		return cipherText;
	}

	public void setCipherText(String cipherText) {
		this.cipherText = cipherText;
	}

	public String getRedFlag() {
		return redFlag;
	}

	public void setRedFlag(String redFlag) {
		this.redFlag = redFlag;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getHandleStatus() {
		return handleStatus;
	}

	public void setHandleStatus(String handleStatus) {
		this.handleStatus = handleStatus;
	}

	public String getLockFlag() {
		return lockFlag;
	}

	public void setLockFlag(String lockFlag) {
		this.lockFlag = lockFlag;
	}

	public String getIdentifyStatus() {
		return identifyStatus;
	}

	public void setIdentifyStatus(String identifyStatus) {
		this.identifyStatus = identifyStatus;
	}

	public String getPrintStatus() {
		return printStatus;
	}

	public void setPrintStatus(String printStatus) {
		this.printStatus = printStatus;
	}

	public String getRetreatStatus() {
		return retreatStatus;
	}

	public void setRetreatStatus(String retreatStatus) {
		this.retreatStatus = retreatStatus;
	}

	public String getPaymentStatus() {
		return paymentStatus;
	}

	public void setPaymentStatus(String paymentStatus) {
		this.paymentStatus = paymentStatus;
	}

	public String getExt17() {
		return ext17;
	}

	public void setExt17(String ext17) {
		this.ext17 = ext17;
	}

	public String getSalesbillId() {
		return salesbillId;
	}

	public void setSalesbillId(String salesbillId) {
		this.salesbillId = salesbillId;
	}

	public String getSalesbillNo() {
		return salesbillNo;
	}

	public void setSalesbillNo(String salesbillNo) {
		this.salesbillNo = salesbillNo;
	}

	public String getInvoiceOrigin() {
		return invoiceOrigin;
	}

	public void setInvoiceOrigin(String invoiceOrigin) {
		this.invoiceOrigin = invoiceOrigin;
	}

	public String getOriginInvoiceNo() {
		return originInvoiceNo;
	}

	public void setOriginInvoiceNo(String originInvoiceNo) {
		this.originInvoiceNo = originInvoiceNo;
	}

	public String getOriginInvoiceCode() {
		return originInvoiceCode;
	}

	public void setOriginInvoiceCode(String originInvoiceCode) {
		this.originInvoiceCode = originInvoiceCode;
	}

	public String getInvoiceType() {
		return invoiceType;
	}

	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}

	public String getInvoiceColor() {
		return invoiceColor;
	}

	public void setInvoiceColor(String invoiceColor) {
		this.invoiceColor = invoiceColor;
	}

	public String getBusinessBillType() {
		return businessBillType;
	}

	public void setBusinessBillType(String businessBillType) {
		this.businessBillType = businessBillType;
	}

	public Long getSellerGroupId() {
		return sellerGroupId;
	}

	public void setSellerGroupId(Long sellerGroupId) {
		this.sellerGroupId = sellerGroupId;
	}

	public String getSellerName() {
		return sellerName;
	}

	public void setSellerName(String sellerName) {
		this.sellerName = sellerName;
	}

	public String getSellerNo() {
		return sellerNo;
	}

	public void setSellerNo(String sellerNo) {
		this.sellerNo = sellerNo;
	}

	public Long getPurchaserGroupId() {
		return purchaserGroupId;
	}

	public void setPurchaserGroupId(Long purchaserGroupId) {
		this.purchaserGroupId = purchaserGroupId;
	}

	public String getPurchaserName() {
		return purchaserName;
	}

	public void setPurchaserName(String purchaserName) {
		this.purchaserName = purchaserName;
	}

	public String getPurchaserNo() {
		return purchaserNo;
	}

	public void setPurchaserNo(String purchaserNo) {
		this.purchaserNo = purchaserNo;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getInvoiceKind() {
		return invoiceKind;
	}

	public void setInvoiceKind(String invoiceKind) {
		this.invoiceKind = invoiceKind;
	}
}
