package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsSysRedNoImportDtoInner
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRedNoImportDtoInner {
  @JsonProperty("redNotificationMain")
  private MsSysRedNoImportDtoInnerRedNotificationMain redNotificationMain = null;

  @JsonProperty("redNotificationDetails")
  private List<MsSysRedNoImportDtoInnerRedNotificationDetails> redNotificationDetails = new ArrayList<MsSysRedNoImportDtoInnerRedNotificationDetails>();

  @JsonIgnore
  public MsSysRedNoImportDtoInner redNotificationMain(MsSysRedNoImportDtoInnerRedNotificationMain redNotificationMain) {
    this.redNotificationMain = redNotificationMain;
    return this;
  }

   /**
   * Get redNotificationMain
   * @return redNotificationMain
  **/
  @ApiModelProperty(value = "")
  public MsSysRedNoImportDtoInnerRedNotificationMain getRedNotificationMain() {
    return redNotificationMain;
  }

  public void setRedNotificationMain(MsSysRedNoImportDtoInnerRedNotificationMain redNotificationMain) {
    this.redNotificationMain = redNotificationMain;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInner redNotificationDetails(List<MsSysRedNoImportDtoInnerRedNotificationDetails> redNotificationDetails) {
    this.redNotificationDetails = redNotificationDetails;
    return this;
  }

  public MsSysRedNoImportDtoInner addRedNotificationDetailsItem(MsSysRedNoImportDtoInnerRedNotificationDetails redNotificationDetailsItem) {
    this.redNotificationDetails.add(redNotificationDetailsItem);
    return this;
  }

   /**
   * Get redNotificationDetails
   * @return redNotificationDetails
  **/
  @ApiModelProperty(value = "")
  public List<MsSysRedNoImportDtoInnerRedNotificationDetails> getRedNotificationDetails() {
    return redNotificationDetails;
  }

  public void setRedNotificationDetails(List<MsSysRedNoImportDtoInnerRedNotificationDetails> redNotificationDetails) {
    this.redNotificationDetails = redNotificationDetails;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRedNoImportDtoInner sysRedNoImportDtoInner = (MsSysRedNoImportDtoInner) o;
    return Objects.equals(this.redNotificationMain, sysRedNoImportDtoInner.redNotificationMain) &&
        Objects.equals(this.redNotificationDetails, sysRedNoImportDtoInner.redNotificationDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(redNotificationMain, redNotificationDetails);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysRedNoImportDtoInner {\n");

    sb.append("    redNotificationMain: ").append(toIndentedString(redNotificationMain)).append("\n");
    sb.append("    redNotificationDetails: ").append(toIndentedString(redNotificationDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
