package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiModel(description = "开具状态信息")
@Data
public class NextInvoiceRequest {

    @ApiModelProperty(value = "设备id")
    private Long deviceId;

    @ApiModelProperty(value = "终端id")
    @NotNull
    private Long terminalId;

    @ApiModelProperty(value = "发票主类型")
    @NotBlank
    private String invoiceType;

    @ApiModelProperty(value = "集团id")
    private Long tenantId;


    @ApiModelProperty(value = "设备唯一编码")
    private String deviceUn;

    @ApiModelProperty(value = "终端唯一编码")
    private String terminalUn;

    @ApiModelProperty(value = "销方税号,仅单点登录场景有用")
//    @Getter
//    @Setter
    private String sellerTaxNo;

    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource;

    @ApiModelProperty(value = "数电开票人")
    private String issuer;


    @ApiModelProperty(value = "请求来源")
    private String requestSource;

    @ApiModelProperty("是否乐企通道")
    private Boolean isNaturalSystemFlag;
}
