package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ApiModel
public class OrderInfo {

    @ApiModelProperty("流水号")
    private Long serialNo;

    @JsonProperty("salesbillId")
    private String salesbillId;


    @JsonProperty("salesbillNo")
    private String salesbillNo = null;
    @JsonProperty("sellerNo")
    private String sellerNo = null;
    @JsonProperty("sellerName")
    private String sellerName = null;
    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;
    @JsonProperty("sellerTel")
    private String sellerTel = null;
    @JsonProperty("sellerAddress")
    private String sellerAddress = null;
    @JsonProperty("sellerBankName")
    private String sellerBankName = null;
    @JsonProperty("sellerBankAccount")
    private String sellerBankAccount = null;
    @JsonProperty("sellerTenantId")
    private Long sellerTenantId = null;
    @JsonProperty("sellerGroupId")
    private Long sellerGroupId = null;
    @JsonProperty("sellerId")
    private Long sellerId = null;
    @JsonProperty("purchaserNo")
    private String purchaserNo = null;
    @JsonProperty("purchaserName")
    private String purchaserName = null;
    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo = null;
    @JsonProperty("purchaserTel")
    private String purchaserTel = null;
    @JsonProperty("purchaserAddress")
    private String purchaserAddress = null;
    @JsonProperty("purchaserBankName")
    private String purchaserBankName = null;
    @JsonProperty("purchaserBankAccount")
    private String purchaserBankAccount = null;
    @JsonProperty("purchaserTenantId")
    private Long purchaserTenantId = null;
    @JsonProperty("purchaserGroupId")
    private Long purchaserGroupId = null;
    @JsonProperty("purchaserId")
    private Long purchaserId = null;
    @JsonProperty("systemOrig")
    private String systemOrig = null;
    @JsonProperty("businessBillType")
    private String businessBillType = null;
    @JsonProperty("salesbillType")
    private String salesbillType = null;
    @JsonProperty("invoiceType")
    private String invoiceType = null;
    @JsonProperty("priceMethod")
    private Integer priceMethod = null;
    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;
    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;
    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;
    @JsonProperty("discountWithTax")
    private BigDecimal discountWithTax = null;
    @JsonProperty("discountWithoutTax")
    private BigDecimal discountWithoutTax = null;
    @JsonProperty("discountTax")
    private BigDecimal discountTax = null;
    @JsonProperty("prePayWithoutTax")
    private BigDecimal prePayWithoutTax = null;
    @JsonProperty("prePayTax")
    private BigDecimal prePayTax = null;
    @JsonProperty("prePayWithTax")
    private BigDecimal prePayWithTax = null;
    @JsonProperty("originInvoiceNo")
    private String originInvoiceNo = null;
    @JsonProperty("originInvoiceCode")
    private String originInvoiceCode = null;
    @JsonProperty("redNotification")
    private String redNotification = null;
    @JsonProperty("checkerName")
    private String checkerName = null;
    @JsonProperty("cashierName")
    private String cashierName = null;
    @JsonProperty("invoicerName")
    private String invoicerName = null;
    @JsonProperty("receiveUserEmail")
    private String receiveUserEmail = null;
    @JsonProperty("receiveUserTel")
    private String receiveUserTel = null;
    @JsonProperty("alreadyMakeAmountWithTax")
    private BigDecimal alreadyMakeAmountWithTax = null;
    @JsonProperty("alreadyMakeAmountWithoutTax")
    private BigDecimal alreadyMakeAmountWithoutTax = null;
    @JsonProperty("alreadyMakeAmountTaxAmount")
    private BigDecimal alreadyMakeAmountTaxAmount = null;
    @JsonProperty("sysOrgId")
    private Long sysOrgId = null;
    @JsonProperty("customerNo")
    private String customerNo = null;
    @JsonProperty("status")
    private Integer status = null;
    @JsonProperty("ext1")
    private String ext1 = null;
    @JsonProperty("ext2")
    private String ext2 = null;
    @JsonProperty("ext3")
    private String ext3 = null;
    @JsonProperty("ext4")
    private String ext4 = null;
    @JsonProperty("ext5")
    private String ext5 = null;
    @JsonProperty("ext6")
    private String ext6 = null;
    @JsonProperty("ext7")
    private String ext7 = null;
    @JsonProperty("ext8")
    private String ext8 = null;
    @JsonProperty("ext9")
    private String ext9 = null;
    @JsonProperty("ext10")
    private String ext10 = null;
    @JsonProperty("ext11")
    private String ext11 = null;
    @JsonProperty("ext12")
    private String ext12 = null;
    @JsonProperty("ext13")
    private String ext13 = null;
    @JsonProperty("ext14")
    private String ext14 = null;
    @JsonProperty("ext15")
    private String ext15 = null;
    @JsonProperty("ext16")
    private String ext16 = null;
    @JsonProperty("ext17")
    private String ext17 = null;
    @JsonProperty("ext18")
    private String ext18 = null;
    @JsonProperty("ext19")
    private String ext19 = null;
    @JsonProperty("ext20")
    private String ext20 = null;
    @JsonProperty("ext21")
    private String ext21 = null;
    @JsonProperty("ext22")
    private String ext22 = null;
    @JsonProperty("ext23")
    private String ext23 = null;
    @JsonProperty("ext24")
    private String ext24 = null;
    @JsonProperty("ext25")
    private String ext25 = null;
    @JsonProperty("billItems")
    private List<OrderItem> billItems = new ArrayList();

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("销方公司id")
    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    @ApiModelProperty("已开含税金额")
    public BigDecimal getAlreadyMakeAmountWithTax() {
        return alreadyMakeAmountWithTax;
    }

    @ApiModelProperty("组织机构id")
    public Long getSysOrgId() {
        return sysOrgId;
    }

    public void setSysOrgId(Long sysOrgId) {
        this.sysOrgId = sysOrgId;
    }

    @ApiModelProperty("用户id")
    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public void setAlreadyMakeAmountWithTax(BigDecimal alreadyMakeAmountWithTax) {
        this.alreadyMakeAmountWithTax = alreadyMakeAmountWithTax;
    }

    @ApiModelProperty("已开不含税金额")
    public BigDecimal getAlreadyMakeAmountWithoutTax() {
        return alreadyMakeAmountWithoutTax;
    }

    public void setAlreadyMakeAmountWithoutTax(BigDecimal alreadyMakeAmountWithoutTax) {
        this.alreadyMakeAmountWithoutTax = alreadyMakeAmountWithoutTax;
    }

    @ApiModelProperty("已开税额")
    public BigDecimal getAlreadyMakeAmountTaxAmount() {
        return alreadyMakeAmountTaxAmount;
    }

    public void setAlreadyMakeAmountTaxAmount(BigDecimal alreadyMakeAmountTaxAmount) {
        this.alreadyMakeAmountTaxAmount = alreadyMakeAmountTaxAmount;
    }


    @ApiModelProperty("单据号")
    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    @JsonIgnore
    public OrderInfo sellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
        return this;
    }

    @ApiModelProperty("销方编号")
    public String getSellerNo() {
        return sellerNo;
    }

    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
    }

    @JsonIgnore
    public OrderInfo sellerName(String sellerName) {
        this.sellerName = sellerName;
        return this;
    }

    @ApiModelProperty("销方名称")
    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    @JsonIgnore
    public OrderInfo sellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
        return this;
    }

    @ApiModelProperty("销方税号")
    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    @JsonIgnore
    public OrderInfo sellerTel(String sellerTel) {
        this.sellerTel = sellerTel;
        return this;
    }

    @ApiModelProperty("销方电话")
    public String getSellerTel() {
        return sellerTel;
    }

    public void setSellerTel(String sellerTel) {
        this.sellerTel = sellerTel;
    }

    @JsonIgnore
    public OrderInfo sellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
        return this;
    }

    @ApiModelProperty("销方地址")
    public String getSellerAddress() {
        return sellerAddress;
    }

    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
    }

    @JsonIgnore
    public OrderInfo sellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName;
        return this;
    }

    @ApiModelProperty("销方银行名称")
    public String getSellerBankName() {
        return sellerBankName;
    }

    public void setSellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName;
    }

    @JsonIgnore
    public OrderInfo sellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
        return this;
    }

    @ApiModelProperty("销方银行账号")
    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    @JsonIgnore
    public OrderInfo sellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
        return this;
    }

    @ApiModelProperty("销方租户ID")
    public Long getSellerTenantId() {
        return sellerTenantId;
    }

    public void setSellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    @JsonIgnore
    public OrderInfo purchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
        return this;
    }

    @ApiModelProperty("购方编号")
    public String getPurchaserNo() {
        return purchaserNo;
    }

    public void setPurchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
    }

    @JsonIgnore
    public OrderInfo purchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
        return this;
    }

    @ApiModelProperty("购方名称")
    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    @JsonIgnore
    public OrderInfo purchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
        return this;
    }

    @ApiModelProperty("购方税号")
    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    @JsonIgnore
    public OrderInfo purchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
        return this;
    }

    @ApiModelProperty("购方电话")
    public String getPurchaserTel() {
        return purchaserTel;
    }

    public void setPurchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
    }

    @JsonIgnore
    public OrderInfo purchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
        return this;
    }

    @ApiModelProperty("购方地址")
    public String getPurchaserAddress() {
        return purchaserAddress;
    }

    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
    }

    @JsonIgnore
    public OrderInfo purchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
        return this;
    }

    @ApiModelProperty("购方银行名称")
    public String getPurchaserBankName() {
        return purchaserBankName;
    }

    public void setPurchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
    }

    @JsonIgnore
    public OrderInfo purchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
        return this;
    }

    @ApiModelProperty("购方银行账号")
    public String getPurchaserBankAccount() {
        return purchaserBankAccount;
    }

    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
    }

    @JsonIgnore
    public OrderInfo purchaserTenantId(Long purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
        return this;
    }

    @ApiModelProperty("购方租户ID")
    public Long getPurchaserTenantId() {
        return purchaserTenantId;
    }

    public void setPurchaserTenantId(Long purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }

    @JsonIgnore
    public OrderInfo purchaserId(Long purchaserId) {
        this.purchaserId = purchaserId;
        return this;
    }

    @ApiModelProperty("购方公司ID")
    public Long getPurchaserId() {
        return purchaserId;
    }

    public void setPurchaserId(Long purchaserId) {
        this.purchaserId = purchaserId;
    }

    @JsonIgnore
    public OrderInfo systemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
        return this;
    }

    @ApiModelProperty("系统来源")
    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    @JsonIgnore
    public OrderInfo businessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
        return this;
    }

    @ApiModelProperty("单据上传方 AR-销方 AP-购方")
    public String getBusinessBillType() {
        return businessBillType;
    }

    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
    }

    @JsonIgnore
    public OrderInfo salesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
        return this;
    }

    @ApiModelProperty("业务单据类型")
    public String getSalesbillType() {
        return salesbillType;
    }

    public void setSalesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
    }

    @JsonIgnore
    public OrderInfo invoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    @ApiModelProperty("发票类型")
    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    @JsonIgnore
    public OrderInfo priceMethod(Integer priceMethod) {
        this.priceMethod = priceMethod;
        return this;
    }

    @ApiModelProperty("计价方式")
    public Integer getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(Integer priceMethod) {
        this.priceMethod = priceMethod;
    }

    @JsonIgnore
    public OrderInfo amountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
        return this;
    }

    @ApiModelProperty("含税金额")
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @JsonIgnore
    public OrderInfo amountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    @ApiModelProperty("不含税金额")
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public OrderInfo taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty("税额")
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    @JsonIgnore
    public OrderInfo discountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
        return this;
    }

    @ApiModelProperty("含税折扣")
    public BigDecimal getDiscountWithTax() {
        return discountWithTax;
    }

    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    @JsonIgnore
    public OrderInfo discountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
        return this;
    }

    @ApiModelProperty("不含税折扣")
    public BigDecimal getDiscountWithoutTax() {
        return discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    @JsonIgnore
    public OrderInfo discountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
        return this;
    }

    @ApiModelProperty("折扣税额")
    public BigDecimal getDiscountTax() {
        return discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    @JsonIgnore
    public OrderInfo prePayWithoutTax(BigDecimal prePayWithoutTax) {
        this.prePayWithoutTax = prePayWithoutTax;
        return this;
    }

    @ApiModelProperty("预付不含税金额")
    public BigDecimal getPrePayWithoutTax() {
        return prePayWithoutTax;
    }

    public void setPrePayWithoutTax(BigDecimal prePayWithoutTax) {
        this.prePayWithoutTax = prePayWithoutTax;
    }

    @JsonIgnore
    public OrderInfo prePayTax(BigDecimal prePayTax) {
        this.prePayTax = prePayTax;
        return this;
    }

    @ApiModelProperty("预付税额")
    public BigDecimal getPrePayTax() {
        return prePayTax;
    }

    public void setPrePayTax(BigDecimal prePayTax) {
        this.prePayTax = prePayTax;
    }

    @JsonIgnore
    public OrderInfo prePayWithTax(BigDecimal prePayWithTax) {
        this.prePayWithTax = prePayWithTax;
        return this;
    }

    @ApiModelProperty("预付含税金额")
    public BigDecimal getPrePayWithTax() {
        return prePayWithTax;
    }

    public void setPrePayWithTax(BigDecimal prePayWithTax) {
        this.prePayWithTax = prePayWithTax;
    }

    @JsonIgnore
    public OrderInfo originInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo;
        return this;
    }

    @ApiModelProperty("原发票号码")
    public String getOriginInvoiceNo() {
        return originInvoiceNo;
    }

    public void setOriginInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo;
    }

    @JsonIgnore
    public OrderInfo originInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode;
        return this;
    }

    @ApiModelProperty("原发票代码")
    public String getOriginInvoiceCode() {
        return originInvoiceCode;
    }

    public void setOriginInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode;
    }

    @JsonIgnore
    public OrderInfo redNotification(String redNotification) {
        this.redNotification = redNotification;
        return this;
    }

    @ApiModelProperty("红字信息编号")
    public String getRedNotification() {
        return redNotification;
    }

    public void setRedNotification(String redNotification) {
        this.redNotification = redNotification;
    }

    @JsonIgnore
    public OrderInfo checkerName(String checkerName) {
        this.checkerName = checkerName;
        return this;
    }

    @ApiModelProperty("复核人")
    public String getCheckerName() {
        return checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }

    @JsonIgnore
    public OrderInfo cashierName(String cashierName) {
        this.cashierName = cashierName;
        return this;
    }

    @ApiModelProperty("收款人")
    public String getCashierName() {
        return cashierName;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    @JsonIgnore
    public OrderInfo invoicerName(String invoicerName) {
        this.invoicerName = invoicerName;
        return this;
    }

    @ApiModelProperty("开票人")
    public String getInvoicerName() {
        return invoicerName;
    }

    public void setInvoicerName(String invoicerName) {
        this.invoicerName = invoicerName;
    }

    @JsonIgnore
    public OrderInfo receiveUserEmail(String receiveUserEmail) {
        this.receiveUserEmail = receiveUserEmail;
        return this;
    }

    @ApiModelProperty("接收方邮箱")
    public String getReceiveUserEmail() {
        return receiveUserEmail;
    }

    public void setReceiveUserEmail(String receiveUserEmail) {
        this.receiveUserEmail = receiveUserEmail;
    }

    @JsonIgnore
    public OrderInfo receiveUserTel(String receiveUserTel) {
        this.receiveUserTel = receiveUserTel;
        return this;
    }

    @ApiModelProperty("接收方电话")
    public String getReceiveUserTel() {
        return receiveUserTel;
    }

    public void setReceiveUserTel(String receiveUserTel) {
        this.receiveUserTel = receiveUserTel;
    }

    @JsonIgnore
    public OrderInfo status(Integer status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty("状态")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonIgnore
    public OrderInfo ext1(String ext1) {
        this.ext1 = ext1;
        return this;
    }

    @ApiModelProperty("扩展字段1")
    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    @JsonIgnore
    public OrderInfo ext2(String ext2) {
        this.ext2 = ext2;
        return this;
    }

    @ApiModelProperty("扩展字段2")
    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    @JsonIgnore
    public OrderInfo ext3(String ext3) {
        this.ext3 = ext3;
        return this;
    }

    @ApiModelProperty("扩展字段3")
    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    @JsonIgnore
    public OrderInfo ext4(String ext4) {
        this.ext4 = ext4;
        return this;
    }

    @ApiModelProperty("扩展字段4")
    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    @JsonIgnore
    public OrderInfo ext5(String ext5) {
        this.ext5 = ext5;
        return this;
    }

    @ApiModelProperty("扩展字段5")
    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    @JsonIgnore
    public OrderInfo ext6(String ext6) {
        this.ext6 = ext6;
        return this;
    }

    @ApiModelProperty("扩展字段6")
    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    @JsonIgnore
    public OrderInfo ext7(String ext7) {
        this.ext7 = ext7;
        return this;
    }

    @ApiModelProperty("扩展字段7")
    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    @JsonIgnore
    public OrderInfo ext8(String ext8) {
        this.ext8 = ext8;
        return this;
    }

    @ApiModelProperty("扩展字段8")
    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    @JsonIgnore
    public OrderInfo ext9(String ext9) {
        this.ext9 = ext9;
        return this;
    }

    @ApiModelProperty("扩展字段9")
    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    @JsonIgnore
    public OrderInfo ext10(String ext10) {
        this.ext10 = ext10;
        return this;
    }

    @ApiModelProperty("扩展字段10")
    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    @JsonIgnore
    public OrderInfo ext11(String ext11) {
        this.ext11 = ext11;
        return this;
    }

    @ApiModelProperty("扩展字段11")
    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    @JsonIgnore
    public OrderInfo ext12(String ext12) {
        this.ext12 = ext12;
        return this;
    }

    @ApiModelProperty("扩展字段12")
    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    @JsonIgnore
    public OrderInfo ext13(String ext13) {
        this.ext13 = ext13;
        return this;
    }

    @ApiModelProperty("扩展字段13")
    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    @JsonIgnore
    public OrderInfo ext14(String ext14) {
        this.ext14 = ext14;
        return this;
    }

    @ApiModelProperty("扩展字段14")
    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    @JsonIgnore
    public OrderInfo ext15(String ext15) {
        this.ext15 = ext15;
        return this;
    }

    @ApiModelProperty("扩展字段15")
    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    @JsonIgnore
    public OrderInfo ext16(String ext16) {
        this.ext16 = ext16;
        return this;
    }

    @ApiModelProperty("扩展字段16")
    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    @JsonIgnore
    public OrderInfo ext17(String ext17) {
        this.ext17 = ext17;
        return this;
    }

    @ApiModelProperty("扩展字段17")
    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    @JsonIgnore
    public OrderInfo ext18(String ext18) {
        this.ext18 = ext18;
        return this;
    }

    @ApiModelProperty("扩展字段18")
    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    @JsonIgnore
    public OrderInfo ext19(String ext19) {
        this.ext19 = ext19;
        return this;
    }

    @ApiModelProperty("扩展字段19")
    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    @JsonIgnore
    public OrderInfo ext20(String ext20) {
        this.ext20 = ext20;
        return this;
    }

    @ApiModelProperty("扩展字段20")
    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    @JsonIgnore
    public OrderInfo ext21(String ext21) {
        this.ext21 = ext21;
        return this;
    }

    @ApiModelProperty("扩展字段21")
    public String getExt21() {
        return ext21;
    }

    public void setExt21(String ext21) {
        this.ext21 = ext21;
    }

    @JsonIgnore
    public OrderInfo ext22(String ext22) {
        this.ext22 = ext22;
        return this;
    }

    @ApiModelProperty("扩展字段22")
    public String getExt22() {
        return ext22;
    }

    public void setExt22(String ext22) {
        this.ext22 = ext22;
    }

    @JsonIgnore
    public OrderInfo ext23(String ext23) {
        this.ext23 = ext23;
        return this;
    }

    @ApiModelProperty("扩展字段23")
    public String getExt23() {
        return ext23;
    }

    public void setExt23(String ext23) {
        this.ext23 = ext23;
    }

    @JsonIgnore
    public OrderInfo ext24(String ext24) {
        this.ext24 = ext24;
        return this;
    }

    @ApiModelProperty("扩展字段24")
    public String getExt24() {
        return ext24;
    }

    public void setExt24(String ext24) {
        this.ext24 = ext24;
    }

    @JsonIgnore
    public OrderInfo ext25(String ext25) {
        this.ext25 = ext25;
        return this;
    }

    @ApiModelProperty("扩展字段25")
    public String getExt25() {
        return ext25;
    }

    public void setExt25(String ext25) {
        this.ext25 = ext25;
    }

    public List<OrderItem> getBillItems() {
        return billItems;
    }

    public void setBillItems(List<OrderItem> billItems) {
        this.billItems = billItems;
    }

    public Long getSellerGroupId() {
        return sellerGroupId;
    }

    public void setSellerGroupId(Long sellerGroupId) {
        this.sellerGroupId = sellerGroupId;
    }

    public Long getPurchaserGroupId() {
        return purchaserGroupId;
    }

    public void setPurchaserGroupId(Long purchaserGroupId) {
        this.purchaserGroupId = purchaserGroupId;
    }

    public String getSalesbillId() {
        return salesbillId;
    }

    public void setSalesbillId(String salesbillId) {
        this.salesbillId = salesbillId;
    }

    public Long getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(Long serialNo) {
        this.serialNo = serialNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String toString() {
        return "OrderInfo{" +
                "serialNo=" + serialNo +
                ", salesbillId='" + salesbillId + '\'' +
                ", salesbillNo='" + salesbillNo + '\'' +
                ", sellerNo='" + sellerNo + '\'' +
                ", sellerName='" + sellerName + '\'' +
                ", sellerTaxNo='" + sellerTaxNo + '\'' +
                ", sellerTel='" + sellerTel + '\'' +
                ", sellerAddress='" + sellerAddress + '\'' +
                ", sellerBankName='" + sellerBankName + '\'' +
                ", sellerBankAccount='" + sellerBankAccount + '\'' +
                ", sellerTenantId=" + sellerTenantId +
                ", sellerGroupId=" + sellerGroupId +
                ", sellerId=" + sellerId +
                ", purchaserNo='" + purchaserNo + '\'' +
                ", purchaserName='" + purchaserName + '\'' +
                ", purchaserTaxNo='" + purchaserTaxNo + '\'' +
                ", purchaserTel='" + purchaserTel + '\'' +
                ", purchaserAddress='" + purchaserAddress + '\'' +
                ", purchaserBankName='" + purchaserBankName + '\'' +
                ", purchaserBankAccount='" + purchaserBankAccount + '\'' +
                ", purchaserTenantId=" + purchaserTenantId +
                ", purchaserGroupId=" + purchaserGroupId +
                ", purchaserId=" + purchaserId +
                ", systemOrig='" + systemOrig + '\'' +
                ", businessBillType='" + businessBillType + '\'' +
                ", salesbillType='" + salesbillType + '\'' +
                ", invoiceType='" + invoiceType + '\'' +
                ", priceMethod=" + priceMethod +
                ", amountWithTax=" + amountWithTax +
                ", amountWithoutTax=" + amountWithoutTax +
                ", taxAmount=" + taxAmount +
                ", discountWithTax=" + discountWithTax +
                ", discountWithoutTax=" + discountWithoutTax +
                ", discountTax=" + discountTax +
                ", prePayWithoutTax=" + prePayWithoutTax +
                ", prePayTax=" + prePayTax +
                ", prePayWithTax=" + prePayWithTax +
                ", originInvoiceNo='" + originInvoiceNo + '\'' +
                ", originInvoiceCode='" + originInvoiceCode + '\'' +
                ", redNotification='" + redNotification + '\'' +
                ", checkerName='" + checkerName + '\'' +
                ", cashierName='" + cashierName + '\'' +
                ", invoicerName='" + invoicerName + '\'' +
                ", receiveUserEmail='" + receiveUserEmail + '\'' +
                ", receiveUserTel='" + receiveUserTel + '\'' +
                ", alreadyMakeAmountWithTax=" + alreadyMakeAmountWithTax +
                ", alreadyMakeAmountWithoutTax=" + alreadyMakeAmountWithoutTax +
                ", alreadyMakeAmountTaxAmount=" + alreadyMakeAmountTaxAmount +
                ", sysOrgId=" + sysOrgId +
                ", customerNo='" + customerNo + '\'' +
                ", status=" + status +
                ", ext1='" + ext1 + '\'' +
                ", ext2='" + ext2 + '\'' +
                ", ext3='" + ext3 + '\'' +
                ", ext4='" + ext4 + '\'' +
                ", ext5='" + ext5 + '\'' +
                ", ext6='" + ext6 + '\'' +
                ", ext7='" + ext7 + '\'' +
                ", ext8='" + ext8 + '\'' +
                ", ext9='" + ext9 + '\'' +
                ", ext10='" + ext10 + '\'' +
                ", ext11='" + ext11 + '\'' +
                ", ext12='" + ext12 + '\'' +
                ", ext13='" + ext13 + '\'' +
                ", ext14='" + ext14 + '\'' +
                ", ext15='" + ext15 + '\'' +
                ", ext16='" + ext16 + '\'' +
                ", ext17='" + ext17 + '\'' +
                ", ext18='" + ext18 + '\'' +
                ", ext19='" + ext19 + '\'' +
                ", ext20='" + ext20 + '\'' +
                ", ext21='" + ext21 + '\'' +
                ", ext22='" + ext22 + '\'' +
                ", ext23='" + ext23 + '\'' +
                ", ext24='" + ext24 + '\'' +
                ", ext25='" + ext25 + '\'' +
                ", billItems=" + billItems +
                ", remark='" + remark + '\'' +
                '}';
    }
}
