package com.xforceplus.seller.invoice.client.model;

import java.util.stream.Stream;

/**
 * 预制发票redFlag
 * 红票专用 0-红字业务单生成
 *         5-蓝票红冲生成
 *         10- 红字业务单生成 使用 红字信息开票
 *         25- 蓝票红冲生成 使用 红字信息开票
 */
public enum PreInvoiceRedFlagEnum {

    /**
     *
     */
    ORIGINAL_FROM_RED_BILL(0, "业务单生成"),

    ORIGINAL_FROM_HC(5, "蓝票红冲生成"),

    ORIGINAL_FROM_RED_BILL_RED_NO(10, "红字业务单生成 使用 红字信息开票"),

    ORIGINAL_FROM_HC_RED_NO(25, "蓝票红冲生成 使用 红字信息开票"),

    FROM_RED_CONFIRMATION(30, "红字确认单直接开票");


    private final Integer code;

    private final String description;

    PreInvoiceRedFlagEnum(Integer code, String desc)
    {
        this.code = code;
        this.description = desc;
    }

    public Integer value()
    {
        return  this.code;
    }

    public String description(){return this.description;}

    public static String getPreInvoiceRedFlagDescBy(Integer value) {
        return Stream.of(PreInvoiceRedFlagEnum.values())
                .filter(r -> r.value().equals(value))
                .map(PreInvoiceRedFlagEnum::description)
                .findFirst().orElse(null);
    }

    public static PreInvoiceRedFlagEnum from(Integer value){
       return Stream.of(PreInvoiceRedFlagEnum.values())
               .filter(r -> r.value().equals(value))
               .findFirst().orElse(null);
    }

    /**
     * 是否为蓝票红冲生成的数据
     */
    public static boolean isReverseByBlueInvoice(Integer redFlag) {
        return PreInvoiceRedFlagEnum.ORIGINAL_FROM_HC.value().equals(redFlag)
                || PreInvoiceRedFlagEnum.ORIGINAL_FROM_HC_RED_NO.value().equals(redFlag);
    }
}
