package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class RedInvoiceInfoTableUpdateRequest {
    @JsonProperty("PreInvoiceId")
    private long PreInvoiceId;

    @ApiModelProperty(value = "预制发票id")
    public long getPreInvoiceId() {
        return PreInvoiceId;
    }

    public void setPreInvoiceId(long preInvoiceId) {
        PreInvoiceId = preInvoiceId;
    }

    @ApiModelProperty(value = "红字信息表字段")
    public String getRedInvoiceInfoFileld() {
        return RedInvoiceInfoFileld;
    }

    public void setRedInvoiceInfoFileld(String redInvoiceInfoFileld) {
        RedInvoiceInfoFileld = redInvoiceInfoFileld;
    }

    @JsonProperty("RedInvoiceInfoFileld")
    private String RedInvoiceInfoFileld;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RedInvoiceInfoTableUpdateRequest that = (RedInvoiceInfoTableUpdateRequest) o;
        return PreInvoiceId == that.PreInvoiceId &&
                Objects.equals(RedInvoiceInfoFileld, that.RedInvoiceInfoFileld);
    }

    @Override
    public int hashCode() {
        return Objects.hash(PreInvoiceId, RedInvoiceInfoFileld);
    }
}
