package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * SellerInvoiceQueryByConditionRequest
 */
@ApiModel(description = "发票查询")
@JsonInclude(NON_NULL)
public class SellerInvoiceQueryForOperationRequest {
  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode= null;

    @JsonProperty("invoiceNo")
    private String invoiceNo= null;

    @JsonProperty("paperDrewDate")
    private Date paperDrewDate= null;

    @JsonProperty("preInvoiceId")
    private Long preInvoiceId= null;

    @ApiModelProperty(value = "发票代码")
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    @ApiModelProperty(value = "发票号码")
    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    @ApiModelProperty(value = "开票日期")
    public Date getPaperDrewDate() {
        return paperDrewDate;
    }

    public void setPaperDrewDate(Date paperDrewDate) {
        this.paperDrewDate = paperDrewDate;
    }

    @ApiModelProperty(value = "预制发票id")
    public Long getPreInvoiceId() {
        return preInvoiceId;
    }

    public void setPreInvoiceId(Long preInvoiceId) {
        this.preInvoiceId = preInvoiceId;
    }



  @JsonIgnore
  public SellerInvoiceQueryForOperationRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public SellerInvoiceQueryForOperationRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数据量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数据量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SellerInvoiceQueryForOperationRequest sellerInvoiceQueryByConditionRequest = (SellerInvoiceQueryForOperationRequest) o;
    return Objects.equals(this.pageNo, sellerInvoiceQueryByConditionRequest.pageNo) &&
        Objects.equals(this.pageSize, sellerInvoiceQueryByConditionRequest.pageSize)&&
            Objects.equals(this.invoiceNo, sellerInvoiceQueryByConditionRequest.invoiceNo)&&
            Objects.equals(this.invoiceCode, sellerInvoiceQueryByConditionRequest.invoiceCode)&&
            Objects.equals(this.paperDrewDate, sellerInvoiceQueryByConditionRequest.paperDrewDate)&&
            Objects.equals(this.preInvoiceId, sellerInvoiceQueryByConditionRequest.preInvoiceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SellerInvoiceQueryByConditionRequest {\n");

    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    preInvoiceId: ").append(toIndentedString(preInvoiceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
