package com.xforceplus.seller.invoice.client.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票信息
 */
@ApiModel(description = "预制发票信息")

@JsonInclude(NON_NULL)
@ToString
@EqualsAndHashCode
@Data
public class SellerPreInvoice {
    @JsonProperty("id")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long id = null;

    @JsonProperty("salesbillNo")
    private String salesbillNo = null;

    @JsonProperty("salesbillId")
    private String salesbillId = null;

    @JsonProperty("batchNo")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long batchNo = null;

    @ApiModelProperty("外部批次号")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long outBatchNo;

    @JsonProperty("sellerTenantId")
    private String sellerTenantId = null;

    @JsonProperty("sellerNo")
    private String sellerNo = null;

    @JsonProperty("sellerCode")
    private String sellerCode = null;

    @JsonProperty("sellerName")
    private String sellerName = null;

    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;

    @JsonProperty("sellerTel")
    private String sellerTel = null;

    @JsonProperty("sellerAddress")
    private String sellerAddress = null;

    @JsonProperty("sellerBankName")
    private String sellerBankName = null;

    @JsonProperty("sellerBankAccount")
    private String sellerBankAccount = null;

    @JsonProperty("purchaserName")
    private String purchaserName = null;

    @JsonProperty("purchaserTenantId")
    private String purchaserTenantId = null;

    @JsonProperty("purchaserId")
    private String purchaserId = null;

    @JsonProperty("purchaserNo")
    private String purchaserNo = null;

    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo = null;

    @JsonProperty("purchaserTel")
    private String purchaserTel = null;

    @JsonProperty("purchaserAddress")
    private String purchaserAddress = null;

    @JsonProperty("purchaserBankName")
    private String purchaserBankName = null;

    @JsonProperty("purchaserBankAccount")
    private String purchaserBankAccount = null;

    @JsonProperty("invoiceType")
    private String invoiceType = null;

    @JsonProperty("businessBillType")
    private String businessBillType = null;

    @JsonProperty("salesbillType")
    private String salesbillType = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("machineCode")
    private String machineCode = null;

    @JsonProperty("paperDrawDate")
    private String paperDrawDate = null;

    @JsonProperty("checkCode")
    private String checkCode = null;

    @JsonProperty("cashierName")
    private String cashierName = null;

    @JsonProperty("checkerName")
    private String checkerName = null;

    @JsonProperty("invoicerName")
    private String invoicerName = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("electronicSignature")
    private String electronicSignature = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("cipherText")
    private String cipherText = null;

    @JsonProperty("cipherTextTwoCode")
    private String cipherTextTwoCode = null;

    @JsonProperty("lockFlag")
    private Integer lockFlag = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("modifyMark")
    private Integer modifyMark = null;

    @JsonProperty("createTime")
    private Date createTime = null;

    @JsonProperty("createUserId")
    private String createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Date updateTime = null;

    @JsonProperty("updateUserId")
    private String updateUserId = null;

    @JsonProperty("ext1")
    private String ext1 = null;

    @JsonProperty("ext2")
    private String ext2 = null;

    @JsonProperty("ext3")
    private String ext3 = null;

    @JsonProperty("ext4")
    private String ext4 = null;

    @JsonProperty("ext5")
    private String ext5 = null;

    @JsonProperty("ext6")
    private String ext6 = null;

    @JsonProperty("ext7")
    private String ext7 = null;

    @JsonProperty("ext8")
    private String ext8 = null;

    @JsonProperty("ext9")
    private String ext9 = null;

    @JsonProperty("ext10")
    private String ext10 = null;

    @JsonProperty("ext11")
    private String ext11 = null;

    @JsonProperty("ext12")
    private String ext12 = null;

    @JsonProperty("ext13")
    private String ext13 = null;

    @JsonProperty("ext14")
    private String ext14 = null;

    @JsonProperty("ext15")
    private String ext15 = null;

    @JsonProperty("ext16")
    private String ext16 = null;

    @JsonProperty("ext17")
    private String ext17 = null;

    @JsonProperty("ext18")
    private String ext18 = null;

    @JsonProperty("ext19")
    private String ext19 = null;

    @JsonProperty("ext20")
    private String ext20 = null;

    @JsonProperty("ext21")
    private String ext21 = null;

    @JsonProperty("ext22")
    private String ext22 = null;

    @JsonProperty("ext23")
    private String ext23 = null;

    @JsonProperty("ext24")
    private String ext24 = null;

    @JsonProperty("ext25")
    private String ext25 = null;

    @ApiModelProperty(value = "规则id")
    private Long ruleId;

    @JsonProperty("originInvoiceNo")
    private String originInvoiceNo = null;

    @JsonProperty("originInvoiceCode")
    private String originInvoiceCode = null;

    @JsonProperty("redNotificationNo")
    private String redNotificationNo = null;

    @JsonProperty("originPaperDrawDate")
    private String originPaperDrawDate;

    @JsonProperty("originInvoiceType")
    private String originInvoiceType;

    @JsonProperty("processFlag")
    private String processFlag;

    @JsonProperty("processRemark")
    private String processRemark;

    @JsonProperty("discountRate")
    private String discountRate = null;

    @ApiModelProperty("开具原因")
    private String makingReason = null;

    @ApiModelProperty("接收人电话")
    private String receiveUserTel = null;

    @ApiModelProperty("接收人邮箱")
    private String receiveUserEmail = null;

    @ApiModelProperty("客户编号")
    private String customerNo = null;

    @ApiModelProperty("税率")
    private String taxRate = null;

    @ApiModelProperty("系统来源")
    private String systemOrig = null;

    @ApiModelProperty("组织id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long sysOrgId = null;

    @ApiModelProperty("购方租户id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long purchaserGroupId = null;

    @ApiModelProperty("销方公司id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long sellerId = null;

    @ApiModelProperty("销方租户id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long sellerGroupId = null;

    @ApiModelProperty("发票特殊标识")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Integer specialInvoiceFlag;

    @ApiModelProperty("发票票种")
    private String invoiceKind;

    @ApiModelProperty("税控发票来源")
    private String taxInvoiceSource;

    @ApiModelProperty("系统来源类型")
    private Integer systemOrigType;

    @ApiModelProperty("购方类型")
    private Integer purchaserType;

    @ApiModelProperty("销货清单文件打印标志 (0-否, 1-是)")
    private int saleListFileFlag;

    @JsonProperty("specialAdditions")
    private List<Map<String, Object>> specialAdditions;
    @ApiModelProperty("扩展备注")
    private String extRemark;

    @ApiModelProperty("备注")
    private String originRemark;

    @ApiModelProperty("发票签名 用于抽取匹配")
    private String invoiceSignature;

    @ApiModelProperty("版式文件版本 (0-使用5行模版, 1-使用8行模版)(仅服务器开电票使用) ")
    private String templateVersion;

    @ApiModelProperty("销货清单备注")
    private String listGoodsName;

    @ApiModelProperty("红冲原因")
    private String redReason;

    @ApiModelProperty("发票状态")
    private Integer invoiceStatus;

    /**
     * 打印内容标志 (0-打印单价和数量, 1-不打印单价和数量)
     * 表 : inv_seller_pre_invoice
     * 对应字段 : display_price_quality
     */
    @ApiModelProperty("打印内容标志 ")
    private Integer displayPriceQuality;

    @ApiModelProperty("红字信息表标识（属地用）")
    private Integer redNotificationFlag;

    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long issuerGroupId;

    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long issuerId;

    private String issuerNo;

    private String issuerName;

    private String issuerTaxNo;

    private String issuerTel;

    private String issuerAddress;

    private String issuerBankName;

    private String issuerBankAccount;

    private String sellerIdentityType;

    private Integer sellerType;

    private String sourceTypeCode;

    private String sourceTypeName;

    private String sourceBillNo;

    private Date sourceCreateAt;

    @ApiModelProperty("销方自然人国籍")
    private String sellerNationality;

    @ApiModelProperty("购方自然人证件类型")
    private String purchaserIdentityType;

    @ApiModelProperty("购方自然人国籍")
    private String purchaserNationality;
}
