package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 分页数据
 */
@ApiModel(description = "分页数据")

@JsonInclude(NON_NULL)
public class SellerPreInvoiceQueryResponseResult {

    @ApiModelProperty(value = "总金额")
    private String totalAmount;

    @ApiModelProperty(value = "待确认数量")
    private int waitConfirmedCount;

    @ApiModelProperty(value = "有变更数量")
    private int changedCount;

    @ApiModelProperty(value = "对方确认中数量")
    private int confirmingCount;

    @ApiModelProperty(value = "待开票")
    private int pendingInvoiceCount;

    @JsonProperty("processingInvoiceCount")
    private int processingInvoiceCount;


    @JsonProperty("total")
    private Long total = null;

    @JsonProperty("preInvoices")
    private List<SellerPreInvoice> preInvoices = new ArrayList<SellerPreInvoice>();

    @JsonIgnore
    public SellerPreInvoiceQueryResponseResult total(Long total) {
        this.total = total;
        return this;
    }

    /**
     * Get total
     *
     * @return total
     **/
    @ApiModelProperty(value = "")
    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    @JsonIgnore
    public SellerPreInvoiceQueryResponseResult preInvoices(List<SellerPreInvoice> preInvoices) {
        this.preInvoices = preInvoices;
        return this;
    }

    public SellerPreInvoiceQueryResponseResult addPreInvoicesItem(SellerPreInvoice preInvoicesItem) {
        this.preInvoices.add(preInvoicesItem);
        return this;
    }

    /**
     * Get preInvoices
     *
     * @return preInvoices
     **/
    @ApiModelProperty(value = "")
    public List<SellerPreInvoice> getPreInvoices() {
        return preInvoices;
    }

    public void setPreInvoices(List<SellerPreInvoice> preInvoices) {
        this.preInvoices = preInvoices;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SellerPreInvoiceQueryResponseResult sellerPreInvoiceQueryResponseResult = (SellerPreInvoiceQueryResponseResult) o;
        return Objects.equals(this.total, sellerPreInvoiceQueryResponseResult.total) &&
                Objects.equals(this.preInvoices, sellerPreInvoiceQueryResponseResult.preInvoices);
    }

    @Override
    public int hashCode() {
        return Objects.hash(total, preInvoices);
    }


    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }


    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public int getWaitConfirmedCount() {
        return waitConfirmedCount;
    }

    public void setWaitConfirmedCount(int waitConfirmedCount) {
        this.waitConfirmedCount = waitConfirmedCount;
    }

    public int getChangedCount() {
        return changedCount;
    }

    public void setChangedCount(int changedCount) {
        this.changedCount = changedCount;
    }

    public int getConfirmingCount() {
        return confirmingCount;
    }

    public void setConfirmingCount(int confirmingCount) {
        this.confirmingCount = confirmingCount;
    }

    public int getPendingInvoiceCount() {
        return pendingInvoiceCount;
    }

    public void setPendingInvoiceCount(int pendingInvoiceCount) {
        this.pendingInvoiceCount = pendingInvoiceCount;
    }

    @ApiModelProperty(value = "开票中")
    public int getProcessingInvoiceCount() {
        return processingInvoiceCount;
    }

    public void setProcessingInvoiceCount(int processingInvoiceCount) {
        this.processingInvoiceCount = processingInvoiceCount;
    }

    @Override
    public String toString() {
        return "SellerPreInvoiceQueryResponseResult{" +
                "totalAmount='" + totalAmount + '\'' +
                ", waitConfirmedCount=" + waitConfirmedCount +
                ", changedCount=" + changedCount +
                ", confirmingCount=" + confirmingCount +
                ", pendingInvoiceCount=" + pendingInvoiceCount +
                ", processingInvoiceCount=" + processingInvoiceCount +
                ", total=" + total +
                ", preInvoices=" + preInvoices +
                '}';
    }
}
