package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
@ApiModel(description = "预制发票总金额")
public class SellerPreInvoiceResponse {

    @JsonProperty("code")
    @ApiModelProperty(value = "code")
    private Integer code = 1;

    @JsonProperty("message")
    @ApiModelProperty(value = "message")
    private String message = "获取成功!";

    @JsonProperty("amountWithTaxTotal")
    @ApiModelProperty(value = "预制发票含税总金额")
    private BigDecimal amountWithTaxTotal = BigDecimal.ZERO;

    @JsonIgnore
    public SellerPreInvoiceResponse code(Integer code) {
        this.code = code;
        return this;
    }

    @JsonIgnore
    public SellerPreInvoiceResponse message(String message) {
        this.message = message;
        return this;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BigDecimal getAmountWithTaxTotal() {
        return amountWithTaxTotal;
    }

    public void setAmountWithTaxTotal(BigDecimal amountWithTaxTotal) {
        this.amountWithTaxTotal = amountWithTaxTotal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SellerPreInvoiceResponse that = (SellerPreInvoiceResponse) o;
        return Objects.equals(code, that.code) &&
                Objects.equals(message, that.message) &&
                Objects.equals(amountWithTaxTotal, that.amountWithTaxTotal);
    }

    @Override
    public int hashCode() {

        return Objects.hash(code, message, amountWithTaxTotal);
    }

    @Override
    public String toString() {
        return "SellerPreInvoiceResponse{" +
                "code=" + code +
                ", message='" + message + '\'' +
                ", amountWithTaxTotal=" + amountWithTaxTotal +
                '}';
    }
}
