package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * SendEinvoiceEmailRequest
 */

@JsonInclude(NON_NULL)
@Data
public class SendEinvoiceEmailRequest {
    @JsonProperty("conditions")
    private Conditions conditions = null;

    @JsonProperty("isAllSelected")
    private Boolean isAllSelected = null;

    @JsonProperty("includes")
    private List<Long> includes = new ArrayList<Long>();

    @JsonProperty("excludes")
    private List<Long> excludes = new ArrayList<Long>();

    @JsonProperty("emailList")
    private List<String> emailList = new ArrayList<String>();

    @JsonProperty("telephones")
    private List<String> telephones = new ArrayList<String>();

    private String type;

    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long sellerGroupId;

    private String requestSource;

}
