package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xforceplus.phoenix.split.model.ZeroTaxOption;
import lombok.Getter;
import lombok.Setter;

@ApiModel
public class SplitRule {

    @ApiModelProperty("规则ID")
    private Long ruleId;

    @ApiModelProperty("拆票限额")
    private BigDecimal invoiceLimit;

    @ApiModelProperty("拆票限额是否是含税金额，默认false 不含税  true 含税")
    private boolean limitIsAmountWithTax = Boolean.FALSE;

    @ApiModelProperty("可拆票字段")
    private List<String> splitFiledList  = new ArrayList<>();

    @ApiModelProperty("设备类型")
    private String taxDeviceType;

    @ApiModelProperty("明细顺序")
    private String itemSort;

    @ApiModelProperty("销货清单最大行数")
    private Integer salesListMaxRow;

    @ApiModelProperty("单价数量选项")
    private String unitPriceAmountOps;

    @ApiModelProperty("金额拆分规则")
    private String amountSplitRule;

    @ApiModelProperty("是否支持整形")
    private boolean integerOps = Boolean.FALSE;

    @ApiModelProperty("发票票面明细最大数")
    private Integer invoiceItemMaxRow;

    @ApiModelProperty("发票备注字段列表")
    private List<String> invoiceRemarkFiledList  = new ArrayList<>();

    @ApiModelProperty("折扣模式")
    private String discountMode;

    @ApiModelProperty("销货清单选项")
    private String saleListOption;

    @ApiModelProperty("发票规格")
    private String invoiceSpec;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("固定备注内容")
    private String fixedRemarkText;

    @ApiModelProperty("发票备注字段元数据")
    private List<RemarkFieldMetadata> remarkFiledMetadataBeanList;

    @ApiModelProperty("发票备注字段元数据")
    private List<RemarkFieldMetadata> remarkFiledMetadataList;

    @ApiModelProperty("商品名称拼接字段列表")
    private List<RemarkFieldMetadata> cargoNameFiledMetadatas;
    @ApiModelProperty("自定义商品品名长度, 默认100")
    private Integer cargoNameLength = 200;
    @ApiModelProperty("规格型号称拼接字段列表")
    private List<RemarkFieldMetadata> itemSpecFiledMetadatas;
    @ApiModelProperty("自定义规格型号名称长度, 默认40")
    private Integer itemSpecNameLength = 100;

    @ApiModelProperty("价格方式, 0=不含税，1=含税")
    private PriceMethod priceMethod;

    @ApiModelProperty("补充备注")
    private String extRemark;

    @ApiModelProperty("自定义备注长度 默认168，电票默认130")
    @Min(
            value = 1L,
            message = "长度限制最小为1"
    )
    private Integer customRemarkSize;

    @ApiModelProperty("拆票单价位数")
    @Min(
            value = 1L,
            message = "长度限制最小为1"
    )
    private Integer unitPriceScale;

    @ApiModelProperty("是否支持智能拆分 false:默认不支持 true 支持 拆分预制发票时 支持按字段进行合并")
    private boolean mergeBySplitField = Boolean.FALSE;

    @ApiModelProperty("折扣率限制 取值范围0-100")
    private BigDecimal discountRateLimit = new BigDecimal("100");

    @ApiModelProperty("备注组合后是否去重, 1=去重，0=不去重")
    private boolean remarkDuplicateFlag=Boolean.TRUE;

    @ApiModelProperty("折扣率限制 取值范围0.01-1.27")
    private BigDecimal taxAmountAllowMax;

    @ApiModelProperty("备注是否自动换行")
    private boolean remarkWrapsFlag = Boolean.FALSE;

    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource ;

    @ApiModelProperty("是否隐藏备注字段名称")
    private boolean hideRemarkFieldName = Boolean.FALSE ;

    @ApiModelProperty("是否打印规格型号")
    private boolean printItemSpecFlag = Boolean.TRUE ;


    @ApiModelProperty("备注分隔符 1-，, 2-、3-:： 4-;； 5-- 6-|｜ 7-空格")
    private java.lang.Integer remarkSeparatorType;

    @ApiModelProperty("字段名和字段值分隔符0-[],1-，, 2-、3-:： 4-;； 5-- 6-|｜ 7-空格 8-换行 9-/")
    private Integer remarkKeyValueShowType =null;


    @ApiModelProperty("是否根据明细的价格数量分组，如果是false 不拆分，true: 单价 数量同时为0 或者 为空的明细单独分组")
    private boolean splitByItemPriceQuantityNon;

    @ApiModelProperty(value = "零税率发票类型, 0 = 不处理，1=专改普")
    private ZeroTaxOption zeroTaxOption;

    @ApiModelProperty("是否打印价外折扣转价内")
    private boolean hideOuterAmount = Boolean.FALSE ;

    @ApiModelProperty("数量限额")
    @Getter
    @Setter
    private Map<String, BigDecimal> quantityLimitMap;

    public boolean isHideOuterAmount() {
        return hideOuterAmount;
    }

    public void setHideOuterAmount(boolean hideOuterAmount) {
        this.hideOuterAmount = hideOuterAmount;
    }

    public Integer getRemarkSeparatorType() {
        return remarkSeparatorType;
    }

    public void setRemarkSeparatorType(Integer remarkSeparatorType) {
        this.remarkSeparatorType = remarkSeparatorType;
    }

    public boolean isPrintItemSpecFlag() {
        return printItemSpecFlag;
    }

    public void setPrintItemSpecFlag(boolean printItemSpecFlag) {
        this.printItemSpecFlag = printItemSpecFlag;
    }

    public boolean isHideRemarkFieldName() {
        return hideRemarkFieldName;
    }

    public void setHideRemarkFieldName(boolean hideRemarkFieldName) {
        this.hideRemarkFieldName = hideRemarkFieldName;
    }

    public String getTaxInvoiceSource() {
        return taxInvoiceSource;
    }

    public void setTaxInvoiceSource(String taxInvoiceSource) {
        this.taxInvoiceSource = taxInvoiceSource;
    }

    public boolean isRemarkWrapsFlag() {
        return remarkWrapsFlag;
    }

    public void setRemarkWrapsFlag(boolean remarkWrapsFlag) {
        this.remarkWrapsFlag = remarkWrapsFlag;
    }

    public boolean isRemarkDuplicateFlag() {
        return remarkDuplicateFlag;
    }

    public void setRemarkDuplicateFlag(boolean remarkDuplicateFlag) {
        this.remarkDuplicateFlag = remarkDuplicateFlag;
    }


    public Integer getUnitPriceScale() {
        return unitPriceScale;
    }

    public void setUnitPriceScale(Integer unitPriceScale) {
        this.unitPriceScale = unitPriceScale;
    }

    public BigDecimal getInvoiceLimit() {
        return invoiceLimit;
    }

    public void setInvoiceLimit(BigDecimal invoiceLimit) {
        this.invoiceLimit = invoiceLimit;
    }

    public boolean isLimitIsAmountWithTax() {
        return limitIsAmountWithTax;
    }

    public void setLimitIsAmountWithTax(boolean limitIsAmountWithTax) {
        this.limitIsAmountWithTax = limitIsAmountWithTax;
    }

    public List<String> getSplitFiledList() {
        return splitFiledList;
    }

    public void setSplitFiledList(List<String> splitFiledList) {
        this.splitFiledList = splitFiledList;
    }

    public String getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceType(String taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    public String getItemSort() {
        return itemSort;
    }

    public void setItemSort(String itemSort) {
        this.itemSort = itemSort;
    }

    public Integer getSalesListMaxRow() {
        return salesListMaxRow;
    }

    public void setSalesListMaxRow(Integer salesListMaxRow) {
        this.salesListMaxRow = salesListMaxRow;
    }

    public String getUnitPriceAmountOps() {
        return unitPriceAmountOps;
    }

    public void setUnitPriceAmountOps(String unitPriceAmountOps) {
        this.unitPriceAmountOps = unitPriceAmountOps;
    }

    public String getAmountSplitRule() {
        return amountSplitRule;
    }

    public void setAmountSplitRule(String amountSplitRule) {
        this.amountSplitRule = amountSplitRule;
    }

    public boolean isIntegerOps() {
        return integerOps;
    }

    public void setIntegerOps(boolean integerOps) {
        this.integerOps = integerOps;
    }

    public Integer getInvoiceItemMaxRow() {
        return invoiceItemMaxRow;
    }

    public void setInvoiceItemMaxRow(Integer invoiceItemMaxRow) {
        this.invoiceItemMaxRow = invoiceItemMaxRow;
    }

    public List<String> getInvoiceRemarkFiledList() {
        return invoiceRemarkFiledList;
    }

    public void setInvoiceRemarkFiledList(List<String> invoiceRemarkFiledList) {
        this.invoiceRemarkFiledList = invoiceRemarkFiledList;
    }

    public String getDiscountMode() {
        return discountMode;
    }

    public void setDiscountMode(String discountMode) {
        this.discountMode = discountMode;
    }

    public String getSaleListOption() {
        return saleListOption;
    }

    public void setSaleListOption(String saleListOption) {
        this.saleListOption = saleListOption;
    }

    public String getInvoiceSpec() {
        return invoiceSpec;
    }

    public void setInvoiceSpec(String invoiceSpec) {
        this.invoiceSpec = invoiceSpec;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }



    public String getFixedRemarkText() {
        return fixedRemarkText;
    }

    public void setFixedRemarkText(String fixedRemarkText) {
        this.fixedRemarkText = fixedRemarkText;
    }

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public List<RemarkFieldMetadata> getRemarkFiledMetadataBeanList() {
        return remarkFiledMetadataBeanList;
    }

    public void setRemarkFiledMetadataBeanList(List<RemarkFieldMetadata> remarkFiledMetadataBeanList) {
        this.remarkFiledMetadataBeanList = remarkFiledMetadataBeanList;
    }

    public PriceMethod getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(PriceMethod priceMethod) {
        this.priceMethod = priceMethod;
    }

    public String getExtRemark() {
        return extRemark;
    }

    public void setExtRemark(String extRemark) {
        this.extRemark = extRemark;
    }

    public List<RemarkFieldMetadata> getRemarkFiledMetadataList() {
        return remarkFiledMetadataList;
    }

    public void setRemarkFiledMetadataList(List<RemarkFieldMetadata> remarkFiledMetadataList) {
        this.remarkFiledMetadataList = remarkFiledMetadataList;
    }

    public List<RemarkFieldMetadata> getCargoNameFiledMetadatas() {
        return cargoNameFiledMetadatas;
    }

    public void setCargoNameFiledMetadatas(List<RemarkFieldMetadata> cargoNameFiledMetadatas) {
        this.cargoNameFiledMetadatas = cargoNameFiledMetadatas;
    }

    public Integer getCargoNameLength() {
        return cargoNameLength;
    }

    public void setCargoNameLength(Integer cargoNameLength) {
        this.cargoNameLength = cargoNameLength;
    }

    public List<RemarkFieldMetadata> getItemSpecFiledMetadatas() {
        return itemSpecFiledMetadatas;
    }

    public void setItemSpecFiledMetadatas(List<RemarkFieldMetadata> itemSpecFiledMetadatas) {
        this.itemSpecFiledMetadatas = itemSpecFiledMetadatas;
    }

    public Integer getItemSpecNameLength() {
        return itemSpecNameLength;
    }

    public void setItemSpecNameLength(Integer itemSpecNameLength) {
        this.itemSpecNameLength = itemSpecNameLength;
    }

    public Integer getCustomRemarkSize() {
        return this.customRemarkSize;
    }

    public void setCustomRemarkSize(Integer customRemarkSize) {
        this.customRemarkSize = customRemarkSize;
    }

    public boolean isMergeBySplitField() {
        return mergeBySplitField;
    }

    public void setMergeBySplitField(boolean mergeBySplitField) {
        this.mergeBySplitField = mergeBySplitField;
    }

    public BigDecimal getDiscountRateLimit() {
        return discountRateLimit;
    }

    public void setDiscountRateLimit(BigDecimal discountRateLimit) {
        this.discountRateLimit = discountRateLimit;
    }

    public BigDecimal getTaxAmountAllowMax() {
        return taxAmountAllowMax;
    }

    public void setTaxAmountAllowMax(BigDecimal taxAmountAllowMax) {
        this.taxAmountAllowMax = taxAmountAllowMax;
    }

    public Integer getRemarkKeyValueShowType() {
        return remarkKeyValueShowType;
    }

    public void setRemarkKeyValueShowType(Integer remarkKeyValueShowType) {
        this.remarkKeyValueShowType = remarkKeyValueShowType;
    }

    @Override
    public String toString() {
        return "SplitRule{" +
                "ruleId=" + ruleId +
                ", invoiceLimit=" + invoiceLimit +
                ", limitIsAmountWithTax=" + limitIsAmountWithTax +
                ", splitFiledList=" + splitFiledList +
                ", taxDeviceType='" + taxDeviceType + '\'' +
                ", itemSort='" + itemSort + '\'' +
                ", salesListMaxRow=" + salesListMaxRow +
                ", unitPriceAmountOps='" + unitPriceAmountOps + '\'' +
                ", amountSplitRule='" + amountSplitRule + '\'' +
                ", integerOps=" + integerOps +
                ", invoiceItemMaxRow=" + invoiceItemMaxRow +
                ", invoiceRemarkFiledList=" + invoiceRemarkFiledList +
                ", discountMode='" + discountMode + '\'' +
                ", saleListOption='" + saleListOption + '\'' +
                ", invoiceSpec='" + invoiceSpec + '\'' +
                ", invoiceType='" + invoiceType + '\'' +
                ", fixedRemarkText='" + fixedRemarkText + '\'' +
                ", remarkFiledMetadataBeanList=" + remarkFiledMetadataBeanList +
                ", remarkFiledMetadataList=" + remarkFiledMetadataList +
                ", cargoNameFiledMetadatas=" + cargoNameFiledMetadatas +
                ", cargoNameLength=" + cargoNameLength +
                ", itemSpecFiledMetadatas=" + itemSpecFiledMetadatas +
                ", itemSpecNameLength=" + itemSpecNameLength +
                ", priceMethod=" + priceMethod +
                ", extRemark='" + extRemark + '\'' +
                ", customRemarkSize=" + customRemarkSize +
                ", unitPriceScale=" + unitPriceScale +
                ", mergeBySplitField=" + mergeBySplitField +
                ", discountRateLimit=" + discountRateLimit +
                ", remarkDuplicateFlag=" + remarkDuplicateFlag +
                ", taxAmountAllowMax=" + taxAmountAllowMax +
                '}';
    }

    public boolean isSplitByItemPriceQuantityNon() {
        return splitByItemPriceQuantityNon;
    }

    public void setSplitByItemPriceQuantityNon(boolean splitByItemPriceQuantityNon) {
        this.splitByItemPriceQuantityNon = splitByItemPriceQuantityNon;
    }

    public ZeroTaxOption getZeroTaxOption() {
        return zeroTaxOption;
    }

    public void setZeroTaxOption(ZeroTaxOption zeroTaxOption) {
        this.zeroTaxOption = zeroTaxOption;
    }
}
