package com.xforceplus.seller.invoice.client.model;

import lombok.Data;

import java.math.BigDecimal;


/**
 * PreInvoicePageInfo
 */

@Data
public class UpdatePreInvoiceByIdRequest {

  private Long id;


  /**
   * 来源：协同90
   */
  private String requestSource;

  /**
   * 批次号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : batch_no
   */
  private Long batchNo;

  /**
   * 系统外批次号  默认batch_no的值
   * 表 : inv_seller_pre_invoice
   * 对应字段 : out_batch_no
   */
  private Long outBatchNo;

  /**
   * 用户Id 下发数据需要  由属地直接传过来
   * 表 : inv_seller_pre_invoice
   * 对应字段 : customer_no
   */
  private String customerNo;

  /**
   * 发票代码
   * 表 : inv_seller_pre_invoice
   * 对应字段 : invoice_code
   */
  private String invoiceCode;

  /**
   * 发票号码
   * 表 : inv_seller_pre_invoice
   * 对应字段 : invoice_no
   */
  private String invoiceNo;

  /**
   * 系统来源  下发数据需要  由属地直接传过来
   * 表 : inv_seller_pre_invoice
   * 对应字段 : system_orig
   */
  private String systemOrig;

  /**
   * 业务单号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : salesbill_no
   */
  private String salesbillNo;

  /**
   * 业务单id
   * 表 : inv_seller_pre_invoice
   * 对应字段 : salesbill_id
   */
  private Long salesbillId;

  /**
   * 购方集团id
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_tenant_id
   */
  private Long purchaserTenantId;

  /**
   * 购方租户ID
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_group_id
   */
  private Long purchaserGroupId;

  /**
   * 购方公司id
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_id
   */
  private Long purchaserId;

  /**
   * 购方编号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_no
   */
  private String purchaserNo;

  /**
   * 购方名称
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_name
   */
  private String purchaserName;

  /**
   * 购方税号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_tax_no
   */
  private String purchaserTaxNo;

  /**
   * 购方电话
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_tel
   */
  private String purchaserTel;

  /**
   * 购方地址
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_address
   */
  private String purchaserAddress;

  /**
   * 购方开户行
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_bank_name
   */
  private String purchaserBankName;

  /**
   * 购方银行账号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_bank_account
   */
  private String purchaserBankAccount;

  /**
   * 销方集团id
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_tenant_id
   */
  private Long sellerTenantId;

  /**
   * 销方租户id
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_group_id
   */
  private Long sellerGroupId;

  /**
   * 销方编号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_no
   */
  private String sellerNo;

  /**
   * 销方税号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_tax_no
   */
  private String sellerTaxNo;

  /**
   * 销方名称
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_name
   */
  private String sellerName;

  /**
   * 销方电话
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_tel
   */
  private String sellerTel;

  /**
   * 销方地址
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_address
   */
  private String sellerAddress;

  /**
   * 销方开户行
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_bank_name
   */
  private String sellerBankName;

  /**
   * 销方银行账号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_bank_account
   */
  private String sellerBankAccount;

  /**
   * 销方公司id
   * 表 : inv_seller_pre_invoice
   * 对应字段 : seller_id
   */
  private Long sellerId;

  /**
   * 发票类型
   * 表 : inv_seller_pre_invoice
   * 对应字段 : invoice_type
   */
  private String invoiceType;

  /**
   * 业务单据类型
   * 表 : inv_seller_pre_invoice
   * 对应字段 : business_bill_type
   */
  private String businessBillType;

  /**
   * 单据类型
   * 表 : inv_seller_pre_invoice
   * 对应字段 : salesbill_type
   */
  private String salesbillType;

  /**
   * 开票日期
   * 表 : inv_seller_pre_invoice
   * 对应字段 : paper_draw_date
   */
  private String paperDrawDate;

  /**
   * 机器编码
   * 表 : inv_seller_pre_invoice
   * 对应字段 : machine_code
   */
  private String machineCode;

  /**
   * 校验码
   * 表 : inv_seller_pre_invoice
   * 对应字段 : check_code
   */
  private String checkCode;

  /**
   * 税率
   * 表 : inv_seller_pre_invoice
   * 对应字段 : tax_rate
   */
  private String taxRate;

  /**
   * 备注
   * 表 : inv_seller_pre_invoice
   * 对应字段 : remark
   */
  private String remark;

  /**
   * 收款人
   * 表 : inv_seller_pre_invoice
   * 对应字段 : cashier_name
   */
  private String cashierName;

  /**
   * 复核人
   * 表 : inv_seller_pre_invoice
   * 对应字段 : checker_name
   */
  private String checkerName;

  /**
   * 开票人
   * 表 : inv_seller_pre_invoice
   * 对应字段 : invoicer_name
   */
  private String invoicerName;

  /**
   * 电子签章
   * 表 : inv_seller_pre_invoice
   * 对应字段 : electronic_signature
   */
  private String electronicSignature;

  /**
   * 预制发票状态，0=删除，1=待确认,2=有变更,3=购方确认中(销方待确认),4=销方确认中(购方待确认),5=待开票,6=开票中,7已开票
   * 表 : inv_seller_pre_invoice
   * 对应字段 : status
   */
  private Integer status;

  /**
   * 业务单修改标记 0-未修改过 0>-修改次数， 这个标记字段从业务单传递过来的
   * 表 : inv_seller_pre_invoice
   * 对应字段 : modify_mark
   */
  private Integer modifyMark;

  /**
   * 预制发票是否锁定;0=未锁;1=锁定;2=开票锁;3=作废锁(蓝票用)
   * 表 : inv_seller_pre_invoice
   * 对应字段 : lock_flag
   */
  private Integer lockFlag;

  /**
   * 红票专用 0-红字业务单生成 5-蓝票红冲生成
   * 表 : inv_seller_pre_invoice
   * 对应字段 : red_flag
   */
  private Integer redFlag;

  /**
   * 规则id
   * 表 : inv_seller_pre_invoice
   * 对应字段 : rule_id
   */
  private Long ruleId;

  /**
   * 组织机构id
   * 表 : inv_seller_pre_invoice
   * 对应字段 : sys_org_id
   */
  private Long sysOrgId;

  /**
   * 原发票号码
   * 表 : inv_seller_pre_invoice
   * 对应字段 : origin_invoice_no
   */
  private String originInvoiceNo;

  /**
   * 原发票代码
   * 表 : inv_seller_pre_invoice
   * 对应字段 : origin_invoice_code
   */
  private String originInvoiceCode;

  /**
   * 原蓝票发票类型
   * 表 : inv_seller_pre_invoice
   * 对应字段 : origin_invoice_type
   */
  private String originInvoiceType;

  /**
   * 原蓝票的开票日期
   * 表 : inv_seller_pre_invoice
   * 对应字段 : origin_paper_draw_date
   */
  private String originPaperDrawDate;

  /**
   * 红字信息表编号
   * 表 : inv_seller_pre_invoice
   * 对应字段 : red_notification_no
   */
  private String redNotificationNo;

  /**
   * 接收方邮箱
   * 表 : inv_seller_pre_invoice
   * 对应字段 : receive_user_email
   */
  private String receiveUserEmail;

  /**
   * 接收方电话
   * 表 : inv_seller_pre_invoice
   * 对应字段 : receive_user_tel
   */
  private String receiveUserTel;

  /**
   * 发票签名 用于抽取匹配
   * 表 : inv_seller_pre_invoice
   * 对应字段 : invoice_signature
   */
  private String invoiceSignature;

  /**
   * 特殊发票标记  0-默认  1-通行费   2-成品油  3- 区块链  4- 机动车专票 9-矿产品

   * 表 : inv_seller_pre_invoice
   * 对应字段 : special_invoice_flag
   */
  private Integer specialInvoiceFlag;

  /**
   * 打印内容标志 (0-打印单价和数量, 1-不打印单价和数量)
   * 表 : inv_seller_pre_invoice
   * 对应字段 : display_price_quality
   */
  private Integer displayPriceQuality;

  /**
   * 销货清单文件打印标志 (0-否, 1-是)
   * 表 : inv_seller_pre_invoice
   * 对应字段 : sale_list_file_flag
   */
  private Integer saleListFileFlag;

  /**
   * 版式文件版本 (0-使用5行模版, 1-使用8行模版)(仅服务器开电票使用)
   * 表 : inv_seller_pre_invoice
   * 对应字段 : template_version
   */
  private Integer templateVersion;

  /**
   * 销货清单备注
   * 表 : inv_seller_pre_invoice
   * 对应字段 : list_goods_name
   */
  private String listGoodsName;

  /**
   * 单据合并类型 0-未合并 1-自动组合 2-自动合并
   * 表 : inv_seller_pre_invoice
   * 对应字段 : merge_type
   */
  private Integer mergeType;

  /**
   * 扩展字段1
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext1
   */
  private String ext1;

  /**
   * 扩展字段2
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext2
   */
  private String ext2;

  /**
   * 扩展字段3
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext3
   */
  private String ext3;

  /**
   * 扩展字段4
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext4
   */
  private String ext4;

  /**
   * 扩展字段5
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext5
   */
  private String ext5;

  /**
   * 扩展字段6
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext6
   */
  private String ext6;

  /**
   * 扩展字段7
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext7
   */
  private String ext7;

  /**
   * 扩展字段8
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext8
   */
  private String ext8;

  /**
   * 扩展字段9
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext9
   */
  private String ext9;

  /**
   * 扩展字段10
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext10
   */
  private String ext10;

  /**
   * 扩展字段11
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext11
   */
  private String ext11;

  /**
   * 扩展字段12
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext12
   */
  private String ext12;

  /**
   * 扩展字段13
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext13
   */
  private String ext13;

  /**
   * 扩展字段14
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext14
   */
  private String ext14;

  /**
   * 扩展字段15
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext15
   */
  private String ext15;

  /**
   * 扩展字段16
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext16
   */
  private String ext16;

  /**
   * 扩展字段17
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext17
   */
  private String ext17;

  /**
   * 扩展字段18
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext18
   */
  private String ext18;

  /**
   * 扩展字段19
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext19
   */
  private String ext19;

  /**
   * 扩展字段20
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext20
   */
  private String ext20;

  /**
   * 扩展字段21
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext21
   */
  private String ext21;

  /**
   * 扩展字段22
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext22
   */
  private String ext22;

  /**
   * 扩展字段23
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext23
   */
  private String ext23;

  /**
   * 扩展字段24
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext24
   */
  private String ext24;

  /**
   * 扩展字段25
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext25
   */
  private String ext25;

  /**
   * 物流 收件人
   * 表 : inv_seller_pre_invoice
   * 对应字段 : addressee
   */
  private String addressee;

  /**
   * 物流-收件人电话
   * 表 : inv_seller_pre_invoice
   * 对应字段 : addressee_tel
   */
  private String addresseeTel;

  /**
   * 物流-收件人省份
   * 表 : inv_seller_pre_invoice
   * 对应字段 : addressee_province
   */
  private String addresseeProvince;

  /**
   * 物流-收件人城市
   * 表 : inv_seller_pre_invoice
   * 对应字段 : addressee_city
   */
  private String addresseeCity;

  /**
   * 物流-收件人所在县区
   * 表 : inv_seller_pre_invoice
   * 对应字段 : addressee_county
   */
  private String addresseeCounty;

  /**
   * 物流-收件人地址
   * 表 : inv_seller_pre_invoice
   * 对应字段 : direction
   */
  private String direction;

  /**
   * 物流备注
   * 表 : inv_seller_pre_invoice
   * 对应字段 : logistic_remark
   */
  private String logisticRemark;

  /**
   * 收件人所在单位
   * 表 : inv_seller_pre_invoice
   * 对应字段 : addressee_comp
   */
  private String addresseeComp;

  /**
   * 收件人邮编
   * 表 : inv_seller_pre_invoice
   * 对应字段 : addressee_post
   */
  private String addresseePost;

  /**
   * 系统来源类型: 0接口传入，1页面导入
   * 表 : inv_seller_pre_invoice
   * 对应字段 : system_orig_type
   */
  private Integer systemOrigType;

  /**
   * 1/0时 代成功与否状态,如果是一串编码代表错误码
   * 表 : inv_seller_pre_invoice
   * 对应字段 : process_flag
   */
  private String processFlag;

  /**
   * 处理备注
   * 表 : inv_seller_pre_invoice
   * 对应字段 : process_remark
   */
  private String processRemark;

  /**
   * 折扣率
   * 表 : inv_seller_pre_invoice
   * 对应字段 : discount_rate
   */
  private BigDecimal discountRate;

  /**
   * 开具原因 空-默认 sales_return - 销货退回，making_error - 开票有误，taxable_service_end - 应税服务终止，sales_allowance - 发生销售折让
   * 表 : inv_seller_pre_invoice
   * 对应字段 : making_reason
   */
  private String makingReason;

  /**
   * 开票方式 0-否 1-是
   * 表 : inv_seller_pre_invoice
   * 对应字段 : make_type
   */
  private Integer makeType;

  /**
   * 发票票种 s-纸专; se-电专; c-纸普; ce-电普; v-机动车; vs-二手机动车; ju-卷票
   * 表 : inv_seller_pre_invoice
   * 对应字段 : invoice_kind
   */
  private String invoiceKind;

  /**
   * 税控发票来源 qd-数电发票 sk-税控发票
   * 表 : inv_seller_pre_invoice
   * 对应字段 : tax_invoice_source
   */
  private String taxInvoiceSource;

  /**
   * 渠道
   * 表 : inv_seller_pre_invoice
   * 对应字段 : channel
   */
  private String channel;

  /**
   * 数电发票号码
   * 表 : inv_seller_pre_invoice
   * 对应字段 : all_electric_invoice_no
   */
  private String allElectricInvoiceNo;

  /**
   * 自定义备注
   * 表 : inv_seller_pre_invoice
   * 对应字段 : ext_remark
   */
  private String extRemark;

  /**
   * 发票来源方 0-4.0平台 1-协同产品线
   * 表 : inv_seller_pre_invoice
   * 对应字段 : invoice_from
   */
  private String invoiceFrom;

  /**
   * 购方类型 1-企业 2-个人
   * 表 : inv_seller_pre_invoice
   * 对应字段 : purchaser_type
   */
  private Integer purchaserType;

  private Integer redNotificationFlag;

}
