package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票请求参数
 */
@ApiModel(description = "预制发票请求参数")

@JsonInclude(NON_NULL)
public class UpdatePreInvoicesRemarkRequest {

  @JsonProperty("preInvoiceIdList")
  private List<Long> preInvoiceIdList = new ArrayList<Long>();

  @JsonProperty("remark")
  private String remark = null;


  @JsonIgnore
  public UpdatePreInvoicesRemarkRequest preInvoiceIdList(List<Long> preInvoiceIdList) {
    this.preInvoiceIdList = preInvoiceIdList;
    return this;
  }

  public UpdatePreInvoicesRemarkRequest addPreInvoiceId(Long preInvoiceId) {
    this.preInvoiceIdList.add(preInvoiceId);
    return this;
  }

   /**
   * 预制发票id集合
   * @return includes
  **/
  @ApiModelProperty(value = "预制发票id集合")
  public List<Long> getPreInvoiceIdList() {
    return preInvoiceIdList;
  }

  public void setPreInvoiceIdList(List<Long> preInvoiceIdList) {
    this.preInvoiceIdList = preInvoiceIdList;
  }

  @JsonIgnore
  public UpdatePreInvoicesRemarkRequest remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 待修改的备注信息
   * @return remark
  **/
  @ApiModelProperty(value = "待修改的备注信息")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdatePreInvoicesRemarkRequest preInvoiceRequest = (UpdatePreInvoicesRemarkRequest) o;
    return Objects.equals(this.preInvoiceIdList, preInvoiceRequest.preInvoiceIdList) &&
        Objects.equals(this.remark, preInvoiceRequest.remark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(preInvoiceIdList, remark);
  }


  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  @Override
  public String toString() {
    return "PreInvoiceRequest{" +
            "preInvoiceIdList=" + preInvoiceIdList +
            ", remark=" + remark +
            '}';
  }

}
