package com.xforceplus.seller.invoice.client.model.ant;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * ErrorCollectionModel
 */
@ApiModel(description = "ErrorCollectionModel")

@JsonInclude(NON_NULL)
public class MsErrorCollectionModel {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("code")
  private String code = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("solution")
  private String solution = null;

  @JsonProperty("cause")
  private String cause = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("platform")
  private Integer platform = null;

  @JsonIgnore
  public MsErrorCollectionModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsErrorCollectionModel code(String code) {
    this.code = code;
    return this;
  }

   /**
   * 错误代码
   * @return code
  **/
  @ApiModelProperty(value = "错误代码")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  @JsonIgnore
  public MsErrorCollectionModel description(String description) {
    this.description = description;
    return this;
  }

   /**
   * 错误描述
   * @return description
  **/
  @ApiModelProperty(value = "错误描述")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  @JsonIgnore
  public MsErrorCollectionModel solution(String solution) {
    this.solution = solution;
    return this;
  }

   /**
   * 解决办法
   * @return solution
  **/
  @ApiModelProperty(value = "解决办法")
  public String getSolution() {
    return solution;
  }

  public void setSolution(String solution) {
    this.solution = solution;
  }

  @JsonIgnore
  public MsErrorCollectionModel cause(String cause) {
    this.cause = cause;
    return this;
  }

   /**
   * 错误原因
   * @return cause
  **/
  @ApiModelProperty(value = "错误原因")
  public String getCause() {
    return cause;
  }

  public void setCause(String cause) {
    this.cause = cause;
  }

  @JsonIgnore
  public MsErrorCollectionModel createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsErrorCollectionModel platform(Integer platform) {
    this.platform = platform;
    return this;
  }

   /**
   * 平台 0共用、1协同、2 2.0、3 3.0、4 4.0、5税件、6业务中台
   * @return platform
  **/
  @ApiModelProperty(value = "平台 0共用、1协同、2 2.0、3 3.0、4 4.0、5税件、6业务中台")
  public Integer getPlatform() {
    return platform;
  }

  public void setPlatform(Integer platform) {
    this.platform = platform;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsErrorCollectionModel errorCollectionModel = (MsErrorCollectionModel) o;
    return Objects.equals(this.id, errorCollectionModel.id) &&
        Objects.equals(this.code, errorCollectionModel.code) &&
        Objects.equals(this.description, errorCollectionModel.description) &&
        Objects.equals(this.solution, errorCollectionModel.solution) &&
        Objects.equals(this.cause, errorCollectionModel.cause) &&
        Objects.equals(this.createTime, errorCollectionModel.createTime) &&
        Objects.equals(this.platform, errorCollectionModel.platform);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, code, description, solution, cause, createTime, platform);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsErrorCollectionModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    solution: ").append(toIndentedString(solution)).append("\n");
    sb.append("    cause: ").append(toIndentedString(cause)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
