package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("自定义查询条件")
public class ConditionQueryInfo {
    @JsonIgnore
    private String sequence;
    @ApiModelProperty("字段")
    private String field;
    @ApiModelProperty("操作符 eq,like,gt,ge,lt,le,ne,in,not_in,range")
    private String conditionOp;
    @ApiModelProperty("conditionOp为eq,like,gt,ge,lt,le,ne时,value字段必填")
    private String value;
    @ApiModelProperty("conditionOp为in,not_in,range时,values为必填")
    private List<String> values;

    public ConditionQueryInfo(String sequence, String field, String conditionOp, String value) {
        this.sequence = sequence;
        this.field = field;
        this.conditionOp = conditionOp;
        this.value = value;
    }

    public ConditionQueryInfo(String sequence, String field, String conditionOp, List<String> values) {
        this.sequence = sequence;
        this.field = field;
        this.conditionOp = conditionOp;
        this.values = values;
    }
}
