package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("打印信息")
public class Print {
    @ApiModelProperty("打印状态")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Integer printStatus;
    @ApiModelProperty("销货清单文件打印标识")
    private Boolean saleListFileFlag;
    @ApiModelProperty("打印内容标识")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Integer printContentFlag;
}
