package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

@ApiModel("货物、服务信息")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RedLetterDetailItem {
    @ApiModelProperty("货物或应税劳务编码（税编）")
    private String itemCode;
    @ApiModelProperty("货物或应税劳务名称")
    @NotNull(message = "itemName参数为必填项")
    private String itemName;
    @ApiModelProperty("规格型号")
    private String specification;
    @ApiModelProperty("单位")
    private String unit;
}
