package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

@ApiModel("税收信息")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RedLetterDetailTax {
    @ApiModelProperty("税收分类编码")
    @NotNull(message = "goodsTaxNo参数为必填项")
    private String goodsTaxNo;
    @ApiModelProperty("税编版本编号")
    private String goodsNoVer;
    @ApiModelProperty("是否享受税收优惠政策")
    private String taxPre;
    @ApiModelProperty("享受税收优惠政策内容")
    private String taxPreCon;
    @ApiModelProperty("零税率标识")
    private String zeroTax;
}
