package com.xforceplus.seller.invoice.client.model.pdf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;


@ApiModel(
        description = "经办人"
)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AutoPdfOperatorInfo {
    @JsonProperty("invoiceName")
    private String invoiceName = null;
    @JsonProperty("checkerName")
    private String checkerName = null;
    @JsonProperty("cashierName")
    private String cashierName = null;

    public AutoPdfOperatorInfo() {
    }

    public AutoPdfOperatorInfo(String invoiceName, String checkerName, String cashierName) {
        this.invoiceName = invoiceName;
        this.checkerName = checkerName;
        this.cashierName = cashierName;
    }

    @JsonIgnore
    public AutoPdfOperatorInfo invoiceName(String invoiceName) {
        this.invoiceName = invoiceName;
        return this;
    }

    @ApiModelProperty("开票人")
    public String getInvoiceName() {
        return this.invoiceName;
    }

    public void setInvoiceName(String invoiceName) {
        this.invoiceName = invoiceName;
    }

    @JsonIgnore
    public AutoPdfOperatorInfo checkerName(String checkerName) {
        this.checkerName = checkerName;
        return this;
    }

    @ApiModelProperty("复核人")
    public String getCheckerName() {
        return this.checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }

    @JsonIgnore
    public AutoPdfOperatorInfo cashierName(String cashierName) {
        this.cashierName = cashierName;
        return this;
    }

    @ApiModelProperty("收款人")
    public String getCashierName() {
        return this.cashierName;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AutoPdfOperatorInfo that = (AutoPdfOperatorInfo) o;
        return Objects.equals(invoiceName, that.invoiceName) &&
                Objects.equals(checkerName, that.checkerName) &&
                Objects.equals(cashierName, that.cashierName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(invoiceName, checkerName, cashierName);
    }

    @Override
    public String toString() {
        return "AutoPdfOperatorInfo{" +
                "invoiceName='" + invoiceName + '\'' +
                ", checkerName='" + checkerName + '\'' +
                ", cashierName='" + cashierName + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }
}
