package com.xforceplus.seller.invoice.client.model.update;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "发票更新条件信息")
@Data
@JsonInclude(NON_NULL)
public class BatchUpdateRequest {

  @ApiModelProperty("预制发票id")
  private List<Long> preInvoiceIdList = null;

  @ApiModelProperty("发票id")
  private List<Long> invoiceIdList = null;
  @ApiModelProperty("更新发票list")
  @JsonProperty("fields")
  private Map<String, String> fields;
}
