package com.xforceplus.seller.invoice.client.model.update;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.client.model.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "发票更新条件信息")
@Data
@JsonInclude(NON_NULL)
public class InvoiceUpdateRequest {
  @JsonProperty("sellerGroupId")
  @ApiModelProperty("销方集团Id")
  private Long sellerGroupId = null;

  @JsonProperty("sendMsgFlag")
  @ApiModelProperty("是否触发发票下发 默认true-是")
  private boolean sendMsgFlag = true;

  @ApiModelProperty("更新发票list")
  @JsonProperty("updateInvoiceList")
  private List<SellerInvoiceInfo> updateInvoiceList = null;
}
