/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.common.transfer.configuration;

import com.xforceplus.invoice.common.transfer.converter.Converter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="tower.invoice", ignoreInvalidFields=true)
public class DictMappings {
    private Map<String, DictMaping> dict;

    @PostConstruct
    public void initConverter() {
        this.getDict().forEach((project, dictMapping) -> {
            Optional.ofNullable(dictMapping.getMain()).ifPresent(main -> main.forEach(this::initConverter));
            Optional.ofNullable(dictMapping.getItems()).ifPresent(item -> item.forEach(this::initConverter));
        });
    }

    private void initConverter(String field, FieldValueConfig fieldValueConfig) {
        if (StringUtils.isNotBlank((CharSequence)fieldValueConfig.getConverter())) {
            try {
                fieldValueConfig.converterBean = (Converter)Class.forName(fieldValueConfig.getConverter()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    public <T> T getItemValue(String project, String field, T value) {
        return this.getValue(project, DictType.ITEMS, field, value);
    }

    public <T> T getMainValue(String project, String field, T value) {
        return this.getValue(project, DictType.MAIN, field, value);
    }

    public <T> T getValue(String project, DictType dictType, String field, T value) {
        if (this.dict == null || this.dict.get(project) == null) {
            return value;
        }
        switch (dictType) {
            case MAIN: {
                Map<String, FieldValueConfig> main = this.dict.get(project).getMain();
                return this.getValue(field, value, main, project);
            }
            case ITEMS: {
                Map<String, FieldValueConfig> items = this.dict.get(project).getItems();
                return this.getValue(field, value, items, project);
            }
        }
        return value;
    }

    private <T> T getValue(String field, T value, Map<String, FieldValueConfig> configMap, String project) {
        if (CollectionUtils.isEmpty(configMap)) {
            return value;
        }
        FieldValueConfig config = configMap.get(field);
        if (config == null) {
            return value;
        }
        T result = null;
        if (value != null) {
            result = Optional.ofNullable(config.getValueMappings().get(value.toString())).orElse(null);
        }
        if (result == null && config.getConverterBean() != null && (result = (T)config.getConverterBean().convert(field, value, project)) != null) {
            return result;
        }
        return Optional.ofNullable(result).orElse(value);
    }

    public Map<String, DictMaping> getDict() {
        return this.dict;
    }

    public void setDict(Map<String, DictMaping> dict) {
        this.dict = dict;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DictMappings)) {
            return false;
        }
        DictMappings other = (DictMappings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, DictMaping> this$dict = this.getDict();
        Map<String, DictMaping> other$dict = other.getDict();
        return !(this$dict == null ? other$dict != null : !((Object)this$dict).equals(other$dict));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DictMappings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, DictMaping> $dict = this.getDict();
        result = result * 59 + ($dict == null ? 43 : ((Object)$dict).hashCode());
        return result;
    }

    public String toString() {
        return "DictMappings(dict=" + this.getDict() + ")";
    }

    public static enum DictType {
        MAIN,
        ITEMS;

    }

    public static class FieldValueConfig {
        private Map<String, Object> valueMappings = new HashMap<String, Object>();
        private String converter;
        private Converter converterBean;

        public Map<String, Object> getValueMappings() {
            return this.valueMappings;
        }

        public String getConverter() {
            return this.converter;
        }

        public Converter getConverterBean() {
            return this.converterBean;
        }

        public void setValueMappings(Map<String, Object> valueMappings) {
            this.valueMappings = valueMappings;
        }

        public void setConverter(String converter) {
            this.converter = converter;
        }

        public void setConverterBean(Converter converterBean) {
            this.converterBean = converterBean;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldValueConfig)) {
                return false;
            }
            FieldValueConfig other = (FieldValueConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$valueMappings = this.getValueMappings();
            Map<String, Object> other$valueMappings = other.getValueMappings();
            if (this$valueMappings == null ? other$valueMappings != null : !((Object)this$valueMappings).equals(other$valueMappings)) {
                return false;
            }
            String this$converter = this.getConverter();
            String other$converter = other.getConverter();
            if (this$converter == null ? other$converter != null : !this$converter.equals(other$converter)) {
                return false;
            }
            Converter this$converterBean = this.getConverterBean();
            Converter other$converterBean = other.getConverterBean();
            return !(this$converterBean == null ? other$converterBean != null : !this$converterBean.equals(other$converterBean));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldValueConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $valueMappings = this.getValueMappings();
            result = result * 59 + ($valueMappings == null ? 43 : ((Object)$valueMappings).hashCode());
            String $converter = this.getConverter();
            result = result * 59 + ($converter == null ? 43 : $converter.hashCode());
            Converter $converterBean = this.getConverterBean();
            result = result * 59 + ($converterBean == null ? 43 : $converterBean.hashCode());
            return result;
        }

        public String toString() {
            return "DictMappings.FieldValueConfig(valueMappings=" + this.getValueMappings() + ", converter=" + this.getConverter() + ", converterBean=" + this.getConverterBean() + ")";
        }
    }

    public static class DictMaping {
        private Map<String, FieldValueConfig> main = new HashMap<String, FieldValueConfig>();
        private Map<String, FieldValueConfig> items = new HashMap<String, FieldValueConfig>();

        public Map<String, FieldValueConfig> getMain() {
            return this.main;
        }

        public Map<String, FieldValueConfig> getItems() {
            return this.items;
        }

        public void setMain(Map<String, FieldValueConfig> main) {
            this.main = main;
        }

        public void setItems(Map<String, FieldValueConfig> items) {
            this.items = items;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DictMaping)) {
                return false;
            }
            DictMaping other = (DictMaping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, FieldValueConfig> this$main = this.getMain();
            Map<String, FieldValueConfig> other$main = other.getMain();
            if (this$main == null ? other$main != null : !((Object)this$main).equals(other$main)) {
                return false;
            }
            Map<String, FieldValueConfig> this$items = this.getItems();
            Map<String, FieldValueConfig> other$items = other.getItems();
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DictMaping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, FieldValueConfig> $main = this.getMain();
            result = result * 59 + ($main == null ? 43 : ((Object)$main).hashCode());
            Map<String, FieldValueConfig> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }

        public String toString() {
            return "DictMappings.DictMaping(main=" + this.getMain() + ", items=" + this.getItems() + ")";
        }
    }
}

