/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.common.transfer.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(value="tower.invoice")
public class FieldMappings {
    private Map<String, ProjectFieldsMapping> fields;

    public String getMappingColumn(String project, String column) {
        if (this.fields == null) {
            return column;
        }
        ProjectFieldsMapping projectFieldsMapping = this.fields.get(project);
        if (projectFieldsMapping == null) {
            return column;
        }
        Map<String, String> mappings = projectFieldsMapping.getMappings();
        if (mappings == null) {
            return column;
        }
        return Optional.ofNullable(mappings.get(column)).orElse(column);
    }

    public boolean inJson(String project, String column) {
        if (this.fields == null || this.fields.get(project) == null) {
            return ProjectFieldsMapping.DEFAULT_JSON.contains(column);
        }
        ProjectFieldsMapping projectFieldsMapping = this.fields.get(project);
        Collection<String> jsonColumns = projectFieldsMapping.getJson();
        if (CollectionUtils.isEmpty(jsonColumns)) {
            return false;
        }
        return jsonColumns.contains(column);
    }

    public boolean isExcluded(String project, String column) {
        if (this.fields == null) {
            return false;
        }
        ProjectFieldsMapping projectFieldsMapping = this.fields.get(project);
        if (projectFieldsMapping == null) {
            return false;
        }
        Collection<String> excludes = projectFieldsMapping.getExclude();
        if (CollectionUtils.isEmpty(excludes)) {
            return false;
        }
        return excludes.contains(column);
    }

    public Map<String, ProjectFieldsMapping> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, ProjectFieldsMapping> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldMappings)) {
            return false;
        }
        FieldMappings other = (FieldMappings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ProjectFieldsMapping> this$fields = this.getFields();
        Map<String, ProjectFieldsMapping> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldMappings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ProjectFieldsMapping> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String toString() {
        return "FieldMappings(fields=" + this.getFields() + ")";
    }

    public static class ProjectFieldsMapping {
        public static final Collection<String> DEFAULT_JSON = Arrays.asList("create_time", "create_user_name", "create_user_id", "update_time", "update_user_name", "update_user_id");
        private Map<String, String> mappings;
        private Collection<String> json;
        private Collection<String> exclude;

        public Map<String, String> getMappings() {
            return this.mappings;
        }

        public Collection<String> getJson() {
            return this.json;
        }

        public Collection<String> getExclude() {
            return this.exclude;
        }

        public void setMappings(Map<String, String> mappings) {
            this.mappings = mappings;
        }

        public void setJson(Collection<String> json) {
            this.json = json;
        }

        public void setExclude(Collection<String> exclude) {
            this.exclude = exclude;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectFieldsMapping)) {
                return false;
            }
            ProjectFieldsMapping other = (ProjectFieldsMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$mappings = this.getMappings();
            Map<String, String> other$mappings = other.getMappings();
            if (this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings)) {
                return false;
            }
            Collection<String> this$json = this.getJson();
            Collection<String> other$json = other.getJson();
            if (this$json == null ? other$json != null : !((Object)this$json).equals(other$json)) {
                return false;
            }
            Collection<String> this$exclude = this.getExclude();
            Collection<String> other$exclude = other.getExclude();
            return !(this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProjectFieldsMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $mappings = this.getMappings();
            result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
            Collection<String> $json = this.getJson();
            result = result * 59 + ($json == null ? 43 : ((Object)$json).hashCode());
            Collection<String> $exclude = this.getExclude();
            result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
            return result;
        }

        public String toString() {
            return "FieldMappings.ProjectFieldsMapping(mappings=" + this.getMappings() + ", json=" + this.getJson() + ", exclude=" + this.getExclude() + ")";
        }
    }
}

