/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.common.transfer.converter;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.xforceplus.invoice.common.constant.ChannelSource;
import com.xforceplus.invoice.common.transfer.configuration.FieldMappings;
import com.xforceplus.invoice.domain.BaseDomain;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityDataConverter {
    private static final Logger log = LoggerFactory.getLogger(EntityDataConverter.class);
    @Autowired
    private FieldMappings fieldMappings;
    private static Map<String, TableFieldInfo> fieldInfoMap = new ConcurrentHashMap<String, TableFieldInfo>();
    private static final String FIELD_KEY = "%s:%s";

    public <T extends BaseDomain> T convert(Class<T> entityClass, Map<String, Serializable> map, ChannelSource channelSource) {
        try {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
            BaseDomain obj = (BaseDomain)entityClass.newInstance();
            obj.setChannelSource(channelSource.getCode());
            map.forEach((k, v) -> this.convertAndSetField(tableInfo, (BaseDomain)obj, (String)k, (Serializable)v, channelSource.getIdentifier()));
            return (T)obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("\u5b9e\u4f53\u5bf9\u8c61\u5b9e\u4f8b\u5316\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5b9e\u4f53\u7c7b:" + entityClass.getName() + "\u4e0d\u5b58\u5728\u6216\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    private <T extends BaseDomain> void convertAndSetField(TableInfo tableInfo, T obj, String column, Serializable value, String project) {
        try {
            Optional<TableFieldInfo> optional;
            if (this.fieldMappings.inJson(project, column)) {
                obj.addBusinessExtend(project, column, (Object)value);
                return;
            }
            if (this.fieldMappings.isExcluded(project, column)) {
                return;
            }
            String actualColumn = this.fieldMappings.getMappingColumn(project, column).toLowerCase();
            String tableName = tableInfo.getTableName();
            String key = String.format(FIELD_KEY, tableName, actualColumn);
            TableFieldInfo tableFieldInfo = fieldInfoMap.get(key);
            if (tableFieldInfo == null && (optional = tableInfo.getFieldList().stream().filter(fieldInfo -> Objects.equals(actualColumn, fieldInfo.getColumn())).findFirst()).isPresent()) {
                tableFieldInfo = optional.get();
                fieldInfoMap.put(key, tableFieldInfo);
            }
            if (tableFieldInfo != null) {
                Field field = tableFieldInfo.getField();
                if (!Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers())) {
                    field.setAccessible(true);
                    if (field.getType().isAssignableFrom(LocalDateTime.class)) {
                        if (value instanceof String) {
                            DateTime dateTime = DateUtil.parse((String)value.toString());
                            field.set(obj, this.toLocalDateTime(dateTime.toJdkDate()));
                        } else if (value instanceof Date) {
                            field.set(obj, this.toLocalDateTime((Date)value));
                        }
                    } else {
                        field.set(obj, value);
                    }
                }
            } else {
                obj.addBusinessExtend(project, column, (Object)value);
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5b57\u6bb5\u8f6c\u6362\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
    }

    private LocalDateTime toLocalDateTime(Date value) {
        Instant instant = value.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public <T extends BaseDomain> T convert(Class<T> entityClass, List<String> cols, Function<String, Serializable> function, ChannelSource channelSource) {
        try {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
            if (tableInfo != null) {
                BaseDomain obj = (BaseDomain)entityClass.newInstance();
                int j = cols.size();
                for (int i = 0; i < j; ++i) {
                    String column = cols.get(i);
                    if (this.fieldMappings.isExcluded(channelSource.getIdentifier(), column)) continue;
                    Serializable value = function.apply(column);
                    this.convertAndSetField(tableInfo, obj, column, value, channelSource.getIdentifier());
                    obj.setChannelSource(channelSource.getCode());
                    obj.setGenerateChannel(channelSource.getCode());
                }
                return (T)obj;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("\u5b9e\u4f53\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5b9e\u4f53\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), e);
        }
        throw new RuntimeException("\u5b9e\u4f53\u7c7b:" + entityClass.getName() + "\u4e0d\u5b58\u5728\u6216\u521d\u59cb\u5316\u5931\u8d25");
    }
}

