/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.common.transfer.policy.update;

import com.xforceplus.api.global.org.OrgApi;
import com.xforceplus.invoice.common.constant.ChannelSource;
import com.xforceplus.invoice.common.transfer.policy.update.AbstractUpdater;
import com.xforceplus.invoice.domain.BaseDomain;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class OrgUpdater<T extends BaseDomain>
extends AbstractUpdater<T> {
    @Autowired
    private OrgApi orgApi;

    @Override
    protected Collection<String> initColumns() {
        return Arrays.asList("seller_company_id", "seller_org_id", "seller_tenant_id", "purchase_company_id", "purchase_org_id", "purchase_tenant_id");
    }

    @Override
    protected int compare(T source, T destination) {
        boolean sourceFlag = ChannelSource.fromCode((int)source.getChannelSource()).isBusinessPlatform();
        boolean destinationFlag = ChannelSource.fromCode((int)destination.getChannelSource()).isBusinessPlatform();
        if (sourceFlag) {
            if (destinationFlag) {
                return 1;
            }
            return -1;
        }
        if (destinationFlag) {
            return 1;
        }
        return -1;
    }

    public OrgApi getOrgApi() {
        return this.orgApi;
    }
}

