/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.common.transfer.policy.update.purchase;

import com.xforceplus.api.common.request.org.OrgQueryRequest;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.invoice.common.transfer.policy.update.OrgUpdater;
import com.xforceplus.invoice.common.transfer.policy.update.purchase.IPurchaserUpdater;
import com.xforceplus.invoice.domain.entity.InvoicePurchaserMain;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"transferInvoicePurchaserMainDao", "transferInvoicePurchaserItemDao"})
public class PurchaserOrgUpdater
extends OrgUpdater<InvoicePurchaserMain>
implements IPurchaserUpdater {
    @Override
    public void compareAndSet(InvoicePurchaserMain source, InvoicePurchaserMain destination) {
        this.set(source, destination, this.compare(source, destination) >= 0);
        if (StringUtils.isNotBlank((CharSequence)destination.getPurchaserTaxNo()) && (Objects.isNull(destination.getPurchaserTenantId()) || Objects.isNull(destination.getPurchaserCompanyId()) || Objects.isNull(destination.getPurchaserOrgId()))) {
            Page pageResult;
            OrgQueryRequest request = new OrgQueryRequest();
            request.setTaxNum(source.getPurchaserTaxNo());
            ResponseEntity responseEntity = this.getOrgApi().page(request, (Pageable)PageRequest.of((int)0, (int)1));
            if (Objects.equals("1", responseEntity.getCode()) && !(pageResult = (Page)responseEntity.getResult()).isEmpty()) {
                OrgDto orgDto = (OrgDto)pageResult.getContent().get(0);
                destination.setPurchaserCompanyId(Optional.ofNullable(destination.getPurchaserCompanyId()).orElse(orgDto.getCompanyId()));
                destination.setPurchaserOrgId(Optional.ofNullable(destination.getPurchaserOrgId()).orElse(orgDto.getOrgId()));
                destination.setPurchaserTenantId(Optional.ofNullable(destination.getPurchaserTenantId()).orElse(orgDto.getTenantId()));
            }
        }
    }
}

