/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.common.transfer.policy.update.seller;

import com.xforceplus.api.common.request.org.OrgQueryRequest;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.invoice.common.transfer.policy.update.OrgUpdater;
import com.xforceplus.invoice.common.transfer.policy.update.seller.ISellerUpdater;
import com.xforceplus.invoice.domain.entity.InvoiceSellerMain;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"transferInvoiceSellerMainDao", "transferInvoiceSellerItemDao"})
public class SellerOrgUpdater
extends OrgUpdater<InvoiceSellerMain>
implements ISellerUpdater {
    @Override
    public void compareAndSet(InvoiceSellerMain source, InvoiceSellerMain destination) {
        OrgDto orgDto;
        Page pageResult;
        ResponseEntity responseEntity;
        OrgQueryRequest request;
        this.set(source, destination, this.compare(source, destination) >= 0);
        if (StringUtils.isNotBlank((CharSequence)destination.getSellerTaxNo()) && (Objects.isNull(destination.getSellerTenantId()) || StringUtils.isBlank((CharSequence)destination.getSellerCompanyId()) || Objects.isNull(destination.getSellerOrgId()))) {
            request = new OrgQueryRequest();
            request.setTaxNum(source.getSellerTaxNo());
            responseEntity = this.getOrgApi().page(request, (Pageable)PageRequest.of((int)0, (int)1));
            if (Objects.equals("1", responseEntity.getCode()) && !(pageResult = (Page)responseEntity.getResult()).isEmpty()) {
                orgDto = (OrgDto)pageResult.getContent().get(0);
                destination.setSellerCompanyId((String)Optional.ofNullable(destination.getSellerCompanyId()).orElse(orgDto.getCompanyId() != null ? orgDto.getCompanyId().toString() : null));
                destination.setSellerOrgId(Optional.ofNullable(destination.getSellerOrgId()).orElse(orgDto.getOrgId()));
                destination.setSellerTenantId(Optional.ofNullable(destination.getSellerTenantId()).orElse(orgDto.getTenantId()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)destination.getPurchaserTaxNo()) && (Objects.isNull(destination.getPurchaserTenantId()) || Objects.isNull(destination.getPurchaserCompanyId()) || Objects.isNull(destination.getPurchaserOrgId()))) {
            request = new OrgQueryRequest();
            request.setTaxNum(source.getPurchaserTaxNo());
            responseEntity = this.getOrgApi().page(request, (Pageable)PageRequest.of((int)0, (int)1));
            if (Objects.equals("1", responseEntity.getCode()) && !(pageResult = (Page)responseEntity.getResult()).isEmpty()) {
                orgDto = (OrgDto)pageResult.getContent().get(0);
                destination.setPurchaserCompanyId((String)Optional.ofNullable(destination.getPurchaserCompanyId()).orElse(orgDto.getCompanyId() != null ? orgDto.getCompanyId().toString() : null));
                destination.setPurchaserOrgId((String)Optional.ofNullable(destination.getPurchaserOrgId()).orElse(orgDto.getOrgId() != null ? orgDto.getOrgId().toString() : null));
                destination.setPurchaserTenantId(Optional.ofNullable(destination.getPurchaserTenantId()).orElse(orgDto.getTenantId()));
            }
        }
    }
}

