/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.common.transfer.service;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.invoice.common.constant.ChannelSource;
import com.xforceplus.invoice.common.transfer.dao.IBaseTransferInvoiceItemDao;
import com.xforceplus.invoice.common.transfer.service.InvoiceItemService;
import com.xforceplus.invoice.domain.BaseDomain;
import com.xforceplus.invoice.domain.typehandler.BusinessExtendMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public abstract class AbstractInvoiceItemService<DAO extends BaseMapper<T>, T extends BaseDomain>
extends ServiceImpl<DAO, T>
implements InvoiceItemService<T, Long> {
    @Autowired
    private IBaseTransferInvoiceItemDao<T> iBaseTransferInvoiceItemDao;

    @Override
    public List<T> findItemsByInvoiceNoAndCode(String invoiceNo, String invoiceCode, String project) {
        return null;
    }

    @Override
    @Transactional
    public void compareAndUpdateItems(String invoiceNo, String invoiceCode, ChannelSource channelSource, List<T> destinations) {
        List<T> sources = this.iBaseTransferInvoiceItemDao.selectByNoAndCode(invoiceNo, invoiceCode);
        this.compareAndSetItemsBusinessExtend(sources, destinations, channelSource);
    }

    private void compareAndSetItemsBusinessExtend(List<T> sources, List<T> destinations, ChannelSource channelSource) {
        int size = sources.size();
        String project = channelSource.getIdentifier();
        for (int i = 0; i < size; ++i) {
            BaseDomain source = (BaseDomain)sources.get(i);
            BaseDomain destination = (BaseDomain)destinations.get(i);
            BusinessExtendMap map = source.getBusinessExtend();
            BusinessExtendMap destinationMap = destination.getBusinessExtend();
            destination.getChannelSource();
            Map sourceProject = (Map)map.get(project);
            Map destinationProject = (Map)destinationMap.get(project);
            if (CollectionUtils.isEmpty((Map)destinationProject)) continue;
            if (CollectionUtils.isEmpty((Map)sourceProject)) {
                this.iBaseTransferInvoiceItemDao.updateExtendById("$." + project, (Map)destinationMap, source.getId(), source.getInvoiceNo(), source.getInvoiceCode());
                continue;
            }
            sourceProject.putAll(destinationProject);
            this.iBaseTransferInvoiceItemDao.updateExtendById("$." + project, sourceProject, source.getId(), source.getInvoiceNo(), source.getInvoiceCode());
        }
    }

    @Override
    public boolean save(T domain, boolean isInsert) {
        if (!isInsert) {
            BusinessExtendMap business = domain.getBusinessExtend();
            if (business != null) {
                ChannelSource channelSource = ChannelSource.fromCode((int)domain.getChannelSource());
                Map json = (Map)business.get(channelSource.getIdentifier());
                Object id = json.get("id");
                T source = this.getiBaseTransferInvoiceItemDao().selectOneByBusinessExtend(domain.getInvoiceNo(), domain.getInvoiceCode(), "$." + channelSource.getIdentifier() + ".id", (Number)id);
                this.compareAndSetItemsBusinessExtend(Collections.singletonList(source), Collections.singletonList(domain), channelSource);
            }
            return true;
        }
        return this.save(domain);
    }

    protected IBaseTransferInvoiceItemDao<T> getiBaseTransferInvoiceItemDao() {
        return this.iBaseTransferInvoiceItemDao;
    }

    @Override
    public abstract boolean save(T var1);
}

