/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.common.transfer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.invoice.common.constant.InvoiceStatus;
import com.xforceplus.invoice.common.constant.RedFlag;
import com.xforceplus.invoice.common.constant.SellerInvoiceColor;
import com.xforceplus.invoice.common.transfer.dao.impl.TransferInvoiceSellerMainDao;
import com.xforceplus.invoice.common.transfer.policy.update.seller.ISellerUpdater;
import com.xforceplus.invoice.common.transfer.service.AbstractInvoiceMainService;
import com.xforceplus.invoice.common.transfer.service.InvoiceSellerItemService;
import com.xforceplus.invoice.common.transfer.service.InvoiceSellerMainService;
import com.xforceplus.invoice.domain.BaseDomain;
import com.xforceplus.invoice.domain.entity.InvoiceSellerItem;
import com.xforceplus.invoice.domain.entity.InvoiceSellerMain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceSellerMainServiceImpl
extends AbstractInvoiceMainService<TransferInvoiceSellerMainDao, InvoiceSellerMain>
implements InvoiceSellerMainService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceSellerMainServiceImpl.class);
    private Collection<ISellerUpdater> sellerUpdaters = new ArrayList<ISellerUpdater>();
    @Autowired
    private InvoiceSellerItemService invoiceSellerItemService;

    @PostConstruct
    public void initUpdaters() {
        Map beans = this.getApplicationContext().getBeansOfType(ISellerUpdater.class);
        if (!CollectionUtils.isEmpty((Map)beans)) {
            beans.values().forEach(bean -> this.sellerUpdaters.add((ISellerUpdater)bean));
        }
    }

    protected InvoiceSellerItemService getItemService() {
        return this.invoiceSellerItemService;
    }

    @Override
    protected Class<? extends BaseDomain> getItemClass() {
        return InvoiceSellerItem.class;
    }

    @Override
    protected Collection<ISellerUpdater> getUpdaters() {
        return this.sellerUpdaters;
    }

    @Override
    protected boolean invokeUpdate(InvoiceSellerMain source, InvoiceSellerMain destination) {
        return ((TransferInvoiceSellerMainDao)this.getBaseMapper()).update(destination, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(InvoiceSellerMain::getId, (Object)destination.getId())).eq(BaseDomain::getInvoiceNo, (Object)destination.getInvoiceNo())).eq(InvoiceSellerMain::getInvoiceCode, (Object)destination.getInvoiceCode())).eq(InvoiceSellerMain::getStatus, (Object)source.getStatus())).eq(InvoiceSellerMain::getRedFlag, (Object)source.getRedFlag())) > 0;
    }

    @Override
    protected boolean validateDestination(InvoiceSellerMain source, InvoiceSellerMain destination) {
        if (source.getStatus() != null && source.getStatus().compareTo(InvoiceStatus.CANCEL.getCode()) == 0 && destination.getStatus() != null && destination.getStatus().compareTo(InvoiceStatus.NORMAL.getCode()) == 0) {
            log.info("\u53d1\u7968[no:{}->code{}]\u5df2\u7ecf\u88ab\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u66f4\u65b0\u6210[\u6b63\u5e38]\u72b6\u6001", (Object)source.getInvoiceNo(), (Object)source.getInvoiceCode());
            return false;
        }
        if (source.getInvoiceColor() != null && source.getInvoiceColor().compareTo(SellerInvoiceColor.BLUE.getCode()) == 0 && source.getRedFlag().compareTo(RedFlag.BE_REDED.getValue()) == 0 && destination.getRedFlag().compareTo(RedFlag.BE_REDED.getValue()) != 0) {
            log.info("\u53d1\u7968[no:{}->code{}]\u5df2\u7ecf\u88ab\u7ea2\u51b2\uff0c\u4e0d\u80fd\u66f4\u65b0\u6210[{}]\u72b6\u6001", new Object[]{source.getInvoiceNo(), source.getInvoiceCode(), destination.getRedFlag()});
            return false;
        }
        return true;
    }
}

