/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.common.constant;

import java.util.Arrays;

public enum ChannelSource {
    ATHENA_SELLER(1, "athena-seller", true),
    ATHENA_PURCHASE(2, "athena-purchase", true),
    PHOENIX_SELLER(3, "phoenix-seller", true),
    PHOENIX_PURCHASE(4, "phoenix-purchase", true),
    INVOICE_MANAGER_SELLER(5, "invoice-manager-seller", true),
    INVOICE_MANAGER_PURCHASE(6, "invoice-manager-purchase", true),
    COOP_SELLER(8, "coop-seller", true),
    COOP_PURCHASE(7, "coop-purchase", true),
    LEDGER_SELLER(9, "ledger-seller", false),
    LEDGER_PURCHASE(10, "ledger-purchase", false);

    private Integer code;
    private String identifier;
    private boolean businessPlatform;

    private ChannelSource(int code, String identifier, boolean businessPlatform) {
        this.code = code;
        this.identifier = identifier;
        this.businessPlatform = businessPlatform;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static ChannelSource fromCode(int code) {
        return Arrays.stream(ChannelSource.values()).filter(channelSource -> channelSource.getCode() == code).findFirst().orElse(null);
    }

    public boolean isBusinessPlatform() {
        return this.businessPlatform;
    }
}

