/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.invoice.inventory.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.micro.tax.device.contract.client.InvoiceStockManagementApi;
import com.xforceplus.phoenix.invoice.inventory.client.model.ExportInvoiceInventoryByConditionRequest;
import com.xforceplus.phoenix.invoice.inventory.client.model.ExportInvoiceInventoryCountByConditionRequest;
import com.xforceplus.phoenix.invoice.inventory.client.model.InventoryFilterCondition;
import com.xforceplus.phoenix.invoice.inventory.client.model.InvoiceInventoryInfo;
import com.xforceplus.phoenix.invoice.inventory.client.model.InvoiceInventoryModel;
import com.xforceplus.phoenix.invoice.inventory.client.model.InvoiceInventoryResponse;
import com.xforceplus.phoenix.invoice.inventory.client.model.InvoiceInventorySummaryModel;
import com.xforceplus.phoenix.invoice.inventory.client.model.InvoiceInventorySummaryResponse;
import com.xforceplus.phoenix.invoice.inventory.client.model.QueryInvoiceInventoryByPageRequest;
import com.xforceplus.phoenix.invoice.inventory.client.model.QueryInvoiceInventorySummary;
import com.xforceplus.phoenix.invoice.inventory.constant.InvoiceInventoryStatusEnum;
import com.xforceplus.phoenix.invoice.inventory.core.service.InvoiceInventoryService;
import com.xforceplus.phoenix.invoice.inventory.manager.InvoiceInventoryManager;
import com.xforceplus.phoenix.invoice.inventory.manager.domian.PageData;
import com.xforceplus.phoenix.invoice.inventory.repository.dao.InvInvoiceInventoryDao;
import com.xforceplus.phoenix.invoice.inventory.repository.daoext.InvInvoiceInventoryExtDao;
import com.xforceplus.phoenix.invoice.inventory.repository.modelext.FilterCondition;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class InvoiceInventoryServiceImpl
implements InvoiceInventoryService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceInventoryServiceImpl.class);
    @Autowired
    private InvoiceStockManagementApi invoiceStockManagementApi;
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    InvoiceInventoryManager invoiceInventoryManager;
    @Autowired
    InvInvoiceInventoryDao invInvoiceInventoryDao;
    @Autowired
    InvInvoiceInventoryExtDao invInvoiceInventoryExtDao;

    public InvoiceInventoryResponse queryInvoiceInventoryByPage(QueryInvoiceInventoryByPageRequest queryInvoiceInventoryByPageRequest) {
        InvoiceInventoryResponse invoiceInventoryResponse = new InvoiceInventoryResponse();
        if (Objects.isNull(queryInvoiceInventoryByPageRequest)) {
            invoiceInventoryResponse.setCode(Response.Fail);
            invoiceInventoryResponse.setMessage("\u53c2\u6570\u4f20\u9012\u9519\u8bef!");
            return invoiceInventoryResponse;
        }
        InventoryFilterCondition inventoryFilterCondition = queryInvoiceInventoryByPageRequest.getInventoryFilterCondition();
        Integer pageNo = queryInvoiceInventoryByPageRequest.getPageNo();
        Integer pageSize = queryInvoiceInventoryByPageRequest.getPageSize();
        PageData invoiceInventoryPageInfo = this.invoiceInventoryManager.queryInvInvoiceInventoryByPage(inventoryFilterCondition, pageNo, pageSize);
        InvoiceInventoryInfo invoiceInventoryInfo = new InvoiceInventoryInfo();
        invoiceInventoryInfo.setInventoryTotalCount(Integer.valueOf((int)invoiceInventoryPageInfo.getCount()));
        List invInvoiceInventoryEntityList = (List)invoiceInventoryPageInfo.getData();
        ArrayList invoiceInventoryModelList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)invInvoiceInventoryEntityList)) {
            invInvoiceInventoryEntityList.forEach(item -> {
                InvoiceInventoryModel invoiceInventoryModel = new InvoiceInventoryModel();
                BeanUtils.copyProperties((Object)item, (Object)invoiceInventoryModel);
                invoiceInventoryModelList.add(invoiceInventoryModel);
            });
        }
        invoiceInventoryInfo.setInvoiceInventoryModelList((List)invoiceInventoryModelList);
        invoiceInventoryResponse.setCode(Response.OK);
        invoiceInventoryResponse.setMessage("\u83b7\u53d6\u6210\u529f!");
        invoiceInventoryResponse.setResult(invoiceInventoryInfo);
        return invoiceInventoryResponse;
    }

    public InvoiceInventorySummaryResponse queryInvoiceInventorySummary(QueryInvoiceInventorySummary queryInvoiceInventorySummary) {
        ArrayList invoiceInventorySummaryModelList = Lists.newArrayList();
        FilterCondition filterCondition = new FilterCondition();
        List inventoryCategoryList = this.invInvoiceInventoryExtDao.queryInventoryCategory(filterCondition);
        if (!CollectionUtils.isEmpty((Collection)inventoryCategoryList)) {
            inventoryCategoryList.forEach(item -> {
                InvoiceInventorySummaryModel invoiceInventorySummaryModel = new InvoiceInventorySummaryModel();
                invoiceInventorySummaryModel.setStatus(item.getStatus());
                invoiceInventorySummaryModel.setTotalCount(item.getTotalCount());
                InvoiceInventoryStatusEnum invoiceInventoryStatusEnum = InvoiceInventoryStatusEnum.fromValue((Integer)item.getStatus());
                invoiceInventorySummaryModel.setName(invoiceInventoryStatusEnum.getName());
                invoiceInventorySummaryModelList.add(invoiceInventorySummaryModel);
            });
        }
        InvoiceInventorySummaryResponse invoiceInventorySummaryResponse = new InvoiceInventorySummaryResponse();
        invoiceInventorySummaryResponse.setCode(Response.OK);
        invoiceInventorySummaryResponse.setMessage("\u83b7\u53d6\u6210\u529f.");
        invoiceInventorySummaryResponse.setResult((List)invoiceInventorySummaryModelList);
        return invoiceInventorySummaryResponse;
    }

    public InvoiceInventoryResponse exportInvoiceInventoryByCondition(ExportInvoiceInventoryByConditionRequest exportInvoiceInventoryByConditionRequest) {
        InvoiceInventoryResponse invoiceInventoryResponse = new InvoiceInventoryResponse();
        List invInvoiceInventoryEntityList = this.invInvoiceInventoryExtDao.queryInvoiceInventoryByCondition(exportInvoiceInventoryByConditionRequest);
        if (CollectionUtils.isEmpty((Collection)invInvoiceInventoryEntityList)) {
            InvoiceInventoryInfo invoiceInventoryInfo = new InvoiceInventoryInfo();
            ArrayList invoiceInventoryModelList = Lists.newArrayList();
            invInvoiceInventoryEntityList.forEach(item -> {
                InvoiceInventoryModel invoiceInventoryModel = new InvoiceInventoryModel();
                BeanUtils.copyProperties((Object)item, (Object)invoiceInventoryModel);
                invoiceInventoryModelList.add(invoiceInventoryModel);
            });
            invoiceInventoryInfo.setInventoryTotalCount(Integer.valueOf(invInvoiceInventoryEntityList.size()));
            invoiceInventoryInfo.setInvoiceInventoryModelList((List)invoiceInventoryModelList);
            invoiceInventoryResponse.setResult(invoiceInventoryInfo);
            invoiceInventoryResponse.setCode(Response.OK);
            return invoiceInventoryResponse;
        }
        invoiceInventoryResponse.setCode(Response.Fail);
        return invoiceInventoryResponse;
    }

    public Response exportInvoiceInventoryCountByCondition(@ApiParam(value="\u67e5\u8be2\u5f85\u5bfc\u51fa\u53d1\u7968\u5e93\u5b58\u6570\u91cf") @RequestBody ExportInvoiceInventoryCountByConditionRequest exportInvoiceInventoryCountByConditionRequest) {
        long exportInvoiceInventoryCount = this.invInvoiceInventoryExtDao.queryInvoiceInventoryCountByCondition(exportInvoiceInventoryCountByConditionRequest);
        return Response.ok((String)"\u83b7\u53d6\u6210\u529f.", (Object)exportInvoiceInventoryCount);
    }
}

