/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.invoice.inventory.manager;

import com.xforceplus.phoenix.invoice.inventory.client.model.InventoryFilterCondition;
import com.xforceplus.phoenix.invoice.inventory.manager.domian.PageData;
import com.xforceplus.phoenix.invoice.inventory.repository.dao.InvInvoiceInventoryDao;
import com.xforceplus.phoenix.invoice.inventory.repository.model.InvInvoiceInventoryEntity;
import com.xforceplus.phoenix.invoice.inventory.repository.model.InvInvoiceInventoryExample;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceInventoryManager {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceInventoryManager.class);
    private InvInvoiceInventoryDao invInvoiceInventoryDao;

    @Autowired
    public InvoiceInventoryManager(InvInvoiceInventoryDao invInvoiceInventoryDao) {
        this.invInvoiceInventoryDao = invInvoiceInventoryDao;
    }

    public PageData<List<InvInvoiceInventoryEntity>> queryInvInvoiceInventoryByPage(InventoryFilterCondition inventoryFilterCondition, Integer pageNo, Integer pageSize) {
        InvInvoiceInventoryExample invInvoiceInventoryExample = new InvInvoiceInventoryExample();
        InvInvoiceInventoryExample.Criteria criteria = invInvoiceInventoryExample.createCriteria();
        if (Objects.nonNull(inventoryFilterCondition)) {
            if (Objects.nonNull(inventoryFilterCondition.getCompanyName())) {
                criteria.andCompanyNameEqualTo(inventoryFilterCondition.getCompanyName());
            }
            if (Objects.nonNull(inventoryFilterCondition.getInvoiceType())) {
                criteria.andInvoiceTypeEqualTo(inventoryFilterCondition.getInvoiceType());
            }
            if (Objects.nonNull(inventoryFilterCondition.getTerminalNo())) {
                criteria.andTerminalNoEqualTo(inventoryFilterCondition.getTerminalNo());
            }
            if (Objects.nonNull(inventoryFilterCondition.getStatus())) {
                criteria.andStatusEqualTo(inventoryFilterCondition.getStatus());
            }
        }
        long count = this.invInvoiceInventoryDao.countByExample(invInvoiceInventoryExample);
        pageNo = pageNo == null ? 1 : pageNo;
        pageSize = pageSize == null ? 20 : pageSize;
        invInvoiceInventoryExample.setLimit(pageSize);
        invInvoiceInventoryExample.setOffset(Integer.valueOf((pageNo - 1) * pageSize));
        List itemEntities = this.invInvoiceInventoryDao.selectByExample(invInvoiceInventoryExample);
        PageData pageData = new PageData();
        pageData.setCount(count);
        pageData.setData((Object)itemEntities);
        return pageData;
    }
}

