/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.janus.config.core.config.TableColumnInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TableInfo {
    private String tableName;
    private String tableComment;
    private String className;
    private boolean enableUpdate;
    private TableInfo subTable;
    private TableColumnInfo pkColumn;
    private String subClassFieldName;
    private String subTableName;
    private String subTableFkName;
    private List<TableColumnInfo> columns;
    private Map<String, TableColumnInfo> javaFieldMap = new HashMap<String, TableColumnInfo>();
    private List<String> fields = new ArrayList<String>();
    private Map<String, TableColumnInfo> columnMap = new HashMap<String, TableColumnInfo>();
    private List<TableColumnInfo> unionFields = null;

    public TableColumnInfo getPK() {
        if (this.pkColumn != null) {
            return this.pkColumn;
        }
        for (TableColumnInfo cl : this.columns) {
            if (!cl.isPk()) continue;
            this.pkColumn = cl;
            return this.pkColumn;
        }
        return null;
    }

    public TableColumnInfo getColumn(String javaField) {
        if (this.javaFieldMap.isEmpty() && this.columns != null) {
            this.columns.forEach(col -> this.javaFieldMap.put(col.getColumnName(), (TableColumnInfo)col));
        }
        return this.javaFieldMap.get(javaField);
    }

    public List<String> getTbFieldNames() {
        if (CollectionUtils.isNotEmpty(this.fields)) {
            return this.fields;
        }
        return this.columns.stream().map(co -> co.getColumnName()).collect(Collectors.toList());
    }

    public TableColumnInfo getJavaField(String columnName) {
        if (this.columnMap.isEmpty() && this.columns != null) {
            this.columns.forEach(col -> this.columnMap.put(col.getColumnName(), (TableColumnInfo)col));
        }
        return this.columnMap.get(columnName);
    }

    public String chooseSelect(Predicate<TableColumnInfo> predicate) {
        String pkSqlSelect = this.getPK().getColumnName();
        String fieldsSqlSelect = this.columns.stream().filter(predicate).map(i -> i.getSqlSelect()).collect(Collectors.joining(","));
        if (StringUtils.isNotEmpty((CharSequence)pkSqlSelect) && StringUtils.isNotEmpty((CharSequence)fieldsSqlSelect)) {
            return pkSqlSelect + "," + fieldsSqlSelect;
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldsSqlSelect)) {
            return fieldsSqlSelect;
        }
        return pkSqlSelect;
    }

    public List<TableColumnInfo> getUnionFields() {
        if (CollectionUtils.isNotEmpty(this.unionFields)) {
            return this.unionFields;
        }
        ArrayList<TableColumnInfo> unionFields = new ArrayList<TableColumnInfo>();
        for (TableColumnInfo column : this.getColumns()) {
            if (!column.isUnionKey()) continue;
            unionFields.add(column);
        }
        return unionFields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isEnableUpdate() {
        return this.enableUpdate;
    }

    public TableInfo getSubTable() {
        return this.subTable;
    }

    public TableColumnInfo getPkColumn() {
        return this.pkColumn;
    }

    public String getSubClassFieldName() {
        return this.subClassFieldName;
    }

    public String getSubTableName() {
        return this.subTableName;
    }

    public String getSubTableFkName() {
        return this.subTableFkName;
    }

    public List<TableColumnInfo> getColumns() {
        return this.columns;
    }

    public Map<String, TableColumnInfo> getJavaFieldMap() {
        return this.javaFieldMap;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Map<String, TableColumnInfo> getColumnMap() {
        return this.columnMap;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setEnableUpdate(boolean enableUpdate) {
        this.enableUpdate = enableUpdate;
    }

    public void setSubTable(TableInfo subTable) {
        this.subTable = subTable;
    }

    public void setPkColumn(TableColumnInfo pkColumn) {
        this.pkColumn = pkColumn;
    }

    public void setSubClassFieldName(String subClassFieldName) {
        this.subClassFieldName = subClassFieldName;
    }

    public void setSubTableName(String subTableName) {
        this.subTableName = subTableName;
    }

    public void setSubTableFkName(String subTableFkName) {
        this.subTableFkName = subTableFkName;
    }

    public void setColumns(List<TableColumnInfo> columns) {
        this.columns = columns;
    }

    public void setJavaFieldMap(Map<String, TableColumnInfo> javaFieldMap) {
        this.javaFieldMap = javaFieldMap;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public void setColumnMap(Map<String, TableColumnInfo> columnMap) {
        this.columnMap = columnMap;
    }

    public void setUnionFields(List<TableColumnInfo> unionFields) {
        this.unionFields = unionFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableInfo)) {
            return false;
        }
        TableInfo other = (TableInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableComment = this.getTableComment();
        String other$tableComment = other.getTableComment();
        if (this$tableComment == null ? other$tableComment != null : !this$tableComment.equals(other$tableComment)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        if (this.isEnableUpdate() != other.isEnableUpdate()) {
            return false;
        }
        TableInfo this$subTable = this.getSubTable();
        TableInfo other$subTable = other.getSubTable();
        if (this$subTable == null ? other$subTable != null : !((Object)this$subTable).equals(other$subTable)) {
            return false;
        }
        TableColumnInfo this$pkColumn = this.getPkColumn();
        TableColumnInfo other$pkColumn = other.getPkColumn();
        if (this$pkColumn == null ? other$pkColumn != null : !((Object)this$pkColumn).equals(other$pkColumn)) {
            return false;
        }
        String this$subClassFieldName = this.getSubClassFieldName();
        String other$subClassFieldName = other.getSubClassFieldName();
        if (this$subClassFieldName == null ? other$subClassFieldName != null : !this$subClassFieldName.equals(other$subClassFieldName)) {
            return false;
        }
        String this$subTableName = this.getSubTableName();
        String other$subTableName = other.getSubTableName();
        if (this$subTableName == null ? other$subTableName != null : !this$subTableName.equals(other$subTableName)) {
            return false;
        }
        String this$subTableFkName = this.getSubTableFkName();
        String other$subTableFkName = other.getSubTableFkName();
        if (this$subTableFkName == null ? other$subTableFkName != null : !this$subTableFkName.equals(other$subTableFkName)) {
            return false;
        }
        List<TableColumnInfo> this$columns = this.getColumns();
        List<TableColumnInfo> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, TableColumnInfo> this$javaFieldMap = this.getJavaFieldMap();
        Map<String, TableColumnInfo> other$javaFieldMap = other.getJavaFieldMap();
        if (this$javaFieldMap == null ? other$javaFieldMap != null : !((Object)this$javaFieldMap).equals(other$javaFieldMap)) {
            return false;
        }
        List<String> this$fields = this.getFields();
        List<String> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Map<String, TableColumnInfo> this$columnMap = this.getColumnMap();
        Map<String, TableColumnInfo> other$columnMap = other.getColumnMap();
        if (this$columnMap == null ? other$columnMap != null : !((Object)this$columnMap).equals(other$columnMap)) {
            return false;
        }
        List<TableColumnInfo> this$unionFields = this.getUnionFields();
        List<TableColumnInfo> other$unionFields = other.getUnionFields();
        return !(this$unionFields == null ? other$unionFields != null : !((Object)this$unionFields).equals(other$unionFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableComment = this.getTableComment();
        result = result * 59 + ($tableComment == null ? 43 : $tableComment.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        result = result * 59 + (this.isEnableUpdate() ? 79 : 97);
        TableInfo $subTable = this.getSubTable();
        result = result * 59 + ($subTable == null ? 43 : ((Object)$subTable).hashCode());
        TableColumnInfo $pkColumn = this.getPkColumn();
        result = result * 59 + ($pkColumn == null ? 43 : ((Object)$pkColumn).hashCode());
        String $subClassFieldName = this.getSubClassFieldName();
        result = result * 59 + ($subClassFieldName == null ? 43 : $subClassFieldName.hashCode());
        String $subTableName = this.getSubTableName();
        result = result * 59 + ($subTableName == null ? 43 : $subTableName.hashCode());
        String $subTableFkName = this.getSubTableFkName();
        result = result * 59 + ($subTableFkName == null ? 43 : $subTableFkName.hashCode());
        List<TableColumnInfo> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, TableColumnInfo> $javaFieldMap = this.getJavaFieldMap();
        result = result * 59 + ($javaFieldMap == null ? 43 : ((Object)$javaFieldMap).hashCode());
        List<String> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Map<String, TableColumnInfo> $columnMap = this.getColumnMap();
        result = result * 59 + ($columnMap == null ? 43 : ((Object)$columnMap).hashCode());
        List<TableColumnInfo> $unionFields = this.getUnionFields();
        result = result * 59 + ($unionFields == null ? 43 : ((Object)$unionFields).hashCode());
        return result;
    }

    public String toString() {
        return "TableInfo(tableName=" + this.getTableName() + ", tableComment=" + this.getTableComment() + ", className=" + this.getClassName() + ", enableUpdate=" + this.isEnableUpdate() + ", subTable=" + this.getSubTable() + ", pkColumn=" + this.getPkColumn() + ", subClassFieldName=" + this.getSubClassFieldName() + ", subTableName=" + this.getSubTableName() + ", subTableFkName=" + this.getSubTableFkName() + ", columns=" + this.getColumns() + ", javaFieldMap=" + this.getJavaFieldMap() + ", fields=" + this.getFields() + ", columnMap=" + this.getColumnMap() + ", unionFields=" + this.getUnionFields() + ")";
    }
}

