/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.context.ApplicationContext;

public class SpringContextUtils {
    public static ApplicationContext applicationContext;

    public SpringContextUtils(ApplicationContext applicationContext) {
        SpringContextUtils.applicationContext = applicationContext;
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        return (T)applicationContext.getBean(name, requiredType);
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)applicationContext.getBean(requiredType);
    }

    public static boolean containsBean(String name) {
        return applicationContext.containsBean(name);
    }

    public static boolean isSingleton(String name) {
        return applicationContext.isSingleton(name);
    }

    public static Class<? extends Object> getType(String name) {
        return applicationContext.getType(name);
    }

    public static <T> Collection<T> getChildren(Class<T> requiredType) {
        Map childrenMap = applicationContext.getBeansOfType(requiredType);
        if (MapUtils.isEmpty((Map)childrenMap)) {
            return new ArrayList();
        }
        return childrenMap.values();
    }
}

