/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.dbsyn.cache;

import com.xforceplus.janus.bridgehead.core.config.TableColumnInfo;
import com.xforceplus.janus.bridgehead.core.config.TableInfo;
import com.xforceplus.janus.db.manager.cache.JdbConfigCache;
import com.xforceplus.janus.db.manager.common.JdbcUrlUtil;
import com.xforceplus.janus.db.manager.service.DataTableService;
import com.xforceplus.janus.dbsyn.config.TbSynConfig;
import com.xforceplus.janus.dbsyn.init.SynThreadLauncher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DbSynCacheManager {
    private static final Logger log = LoggerFactory.getLogger(DbSynCacheManager.class);
    public static Map<String, TbSynConfig> NEED_SYN_TABLES = new ConcurrentHashMap<String, TbSynConfig>();
    public volatile AtomicBoolean loadFromDb = new AtomicBoolean(false);
    @Autowired
    private DataTableService dataTableService;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private SynThreadLauncher synThreadLauncher;

    @Scheduled(cron="0 */30 * * * ?")
    public void loadSynTableCache() {
        try {
            String schema = JdbcUrlUtil.findDbNameFromUrl((String)this.dataSource.getConnection().getMetaData().getURL());
            List tables = this.dataTableService.tableList(schema);
            if (CollectionUtils.isEmpty((Collection)tables)) {
                log.warn("\u65e0\u6cd5\u83b7\u53d6{}\u4e0b\u7684\u6570\u636e\u5e93\u8868", (Object)schema);
                return;
            }
            for (Map table : tables) {
                String tbName = (String)table.get("TABLE_NAME");
                List columns = this.dataTableService.tableColumnList(schema, (String)table.get("TABLE_NAME"));
                TableInfo tableDto = new TableInfo();
                tableDto.setTableName(tbName);
                Object comment = table.get("TABLE_COMMENT");
                tableDto.setTableComment(comment == null || StringUtils.isBlank((CharSequence)((String)comment)) ? tbName : (String)comment);
                tableDto.setColumns(columns);
                JdbConfigCache.TABLES_CACHE.put(tbName, tableDto);
                if (!this.neeSyn(columns) || NEED_SYN_TABLES.containsKey(tbName)) continue;
                TbSynConfig synConfig = new TbSynConfig(tbName);
                synConfig.setGenTable(tableDto);
                tableDto.setEnableUpdate(true);
                NEED_SYN_TABLES.put(tbName, synConfig);
                log.info("\u8868: {} \u540c\u6b65\u4ece\u6570\u636e\u5e93\u52a0\u8f7d\u9700\u8981\u81ea\u52a8\u540c\u6b65\u8868\u4fe1\u606f", (Object)tbName);
            }
            if (NEED_SYN_TABLES.size() > 0) {
                this.synThreadLauncher.launchSyn();
            }
        }
        catch (Exception exception) {
            log.error("\u81ea\u52a8\u83b7\u53d6\u540c\u6b65\u8868\u4fe1\u606f\u5f02\u5e38", (Throwable)exception);
        }
    }

    public void initCache(List<TbSynConfig> synConfigs) {
        synConfigs.forEach(config -> {
            NEED_SYN_TABLES.put(config.getTbName(), (TbSynConfig)config);
            log.info("table {} syn init config from center", (Object)config.getTbName());
        });
        this.synThreadLauncher.launchSyn();
    }

    private boolean neeSyn(List<TableColumnInfo> columns) {
        for (TableColumnInfo col : columns) {
            if (!"janus_syn_flag".equals(col.getColumnName())) continue;
            return true;
        }
        return false;
    }
}

