/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.dbsyn.handle;

import com.xforceplus.janus.bridgehead.core.config.HttpConfig;
import com.xforceplus.janus.dbsyn.config.TbSynConfig;
import com.xforceplus.janus.dbsyn.handle.DataBatchHandler;
import com.xforceplus.janus.dbsyn.handle.HttpRequestDataHandler;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(DataHandlerFactory.class);
    @Autowired
    private HttpConfig sysHttpConfig;

    public DataBatchHandler createHandler(TbSynConfig config) {
        HttpRequestDataHandler dataHandler = null;
        switch (config.getDealType()) {
            case "1": {
                if (StringUtils.isBlank((CharSequence)config.getHostUrl()) && StringUtils.isNotBlank((CharSequence)config.getAction())) {
                    config.setHostUrl(this.sysHttpConfig.getJanusUrl());
                    if (config.getHeaders() == null) {
                        config.setHeaders(new HashMap<String, String>());
                    }
                    config.getHeaders().put("Authentication", this.sysHttpConfig.getAuthentication());
                }
                if (StringUtils.isNotBlank((CharSequence)config.getHostUrl()) && StringUtils.isNotBlank((CharSequence)config.getRequestMethod())) {
                    dataHandler = new HttpRequestDataHandler(config);
                    break;
                }
                log.warn("\u8868 {} init dataHandler failed\uff0curl \u6216 requestmethod is null", (Object)config.getTbName());
                break;
            }
        }
        return dataHandler;
    }
}

