/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.dbsyn.handle;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.HttpUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.dbsyn.config.TbSynConfig;
import com.xforceplus.janus.dbsyn.handle.DataBatchHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestDataHandler
implements DataBatchHandler {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestDataHandler.class);
    private Map<String, String> headers;
    private TbSynConfig tbSynConfig;

    public HttpRequestDataHandler(TbSynConfig tbSynConfig) {
        this.headers = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(tbSynConfig.getHeaders())) {
            this.headers.putAll(tbSynConfig.getHeaders());
        }
        if (StringUtils.isNotBlank((CharSequence)tbSynConfig.getAction())) {
            this.headers.put("action", tbSynConfig.getAction());
            this.headers.put("serialNo", "" + System.currentTimeMillis());
        }
        this.tbSynConfig = tbSynConfig;
    }

    public HttpRequestDataHandler() {
    }

    @Override
    public boolean doHandler(List<Map<String, Object>> datas) {
        if (CollectionUtils.isEmpty(datas)) {
            return true;
        }
        try {
            HttpUtil.ResponseCus responseCus = null;
            if (this.tbSynConfig.getRequestMethod().equalsIgnoreCase("POST")) {
                responseCus = HttpUtil.doPostJsonEntire((String)this.tbSynConfig.getHostUrl(), (String)JacksonUtil.getInstance().toJson(datas), this.headers, null);
            } else if (this.tbSynConfig.getRequestMethod().equalsIgnoreCase("PUT") || this.tbSynConfig.getRequestMethod().equalsIgnoreCase("PATCH")) {
                responseCus = HttpUtil.doPutPatchEntire((String)this.tbSynConfig.getHostUrl(), (String)this.tbSynConfig.getRequestMethod(), (String)JacksonUtil.getInstance().toJson(datas), this.headers, null);
            }
            if (responseCus.getStatus() != 200) {
                return false;
            }
            log.error("invoke url\uff1a{} failed\uff0cresponse:{}", (Object)this.tbSynConfig.getHostUrl(), (Object)responseCus.getBody());
        }
        catch (IOException e) {
            log.error("\u8868:{}\u540c\u6b65\u6570\u636e\u5f02\u5e38:{}", (Object)this.tbSynConfig.getTbName(), (Object)ErrorUtil.getStackMsg((Exception)e));
            return false;
        }
        return true;
    }

    @Override
    public int getSynPageSize() {
        return this.tbSynConfig.getSynPageSize();
    }
}

