/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.dbsyn.init;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.bridgehead.core.config.ConfigHandler;
import com.xforceplus.janus.db.manager.cache.JdbConfigCache;
import com.xforceplus.janus.dbsyn.cache.DbSynCacheManager;
import com.xforceplus.janus.dbsyn.config.TbSynConfig;
import com.xforceplus.janus.dbsyn.init.LocalTableUploader;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DbSynConfigHandler
implements ConfigHandler {
    private static final Logger log = LoggerFactory.getLogger(DbSynConfigHandler.class);
    @Autowired
    private DbSynCacheManager synCacheManager;
    @Autowired(required=false)
    private LocalTableUploader dbConfigUploader;

    public String getConfigKey() {
        return "dbSynConfig";
    }

    public void doHandler(String body) {
        List synConfigs = JacksonUtil.getInstance().fromJsonToList(body, TbSynConfig.class);
        if (CollectionUtils.isNotEmpty((Collection)synConfigs)) {
            synConfigs.forEach(tbConfig -> {
                if (tbConfig.getGenTable() != null) {
                    JdbConfigCache.TABLES_CACHE.put(tbConfig.getTbName(), tbConfig.getGenTable());
                    if (tbConfig.getGenTable().getSubTable() != null) {
                        JdbConfigCache.TABLES_CACHE.put(tbConfig.getGenTable().getSubTableName(), tbConfig.getGenTable().getSubTable());
                    }
                }
            });
        }
        this.synCacheManager.initCache(synConfigs);
    }

    public void nullValueHandler() {
        try {
            if (!this.synCacheManager.loadFromDb.get()) {
                this.synCacheManager.loadSynTableCache();
                if (this.dbConfigUploader != null) {
                    this.dbConfigUploader.uploadTables();
                }
                this.synCacheManager.loadFromDb.set(true);
            }
        }
        catch (Exception ex) {
            log.error("\u81ea\u52a8\u521d\u59cb\u5316\u6570\u636e\u540c\u6b65\u8868\u4fe1\u606f\u5931\u8d25", (Object)ErrorUtil.getStackMsg((Exception)ex));
        }
    }
}

