/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.dbsyn.init;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.HttpUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.bridgehead.core.config.HttpConfig;
import com.xforceplus.janus.bridgehead.core.config.TableInfo;
import com.xforceplus.janus.db.manager.cache.JdbConfigCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocalTableUploader {
    private static final Logger log = LoggerFactory.getLogger(LocalTableUploader.class);
    @Autowired
    private HttpConfig httpConfig;
    private static final int UPLOAD_TABLE_PAGE_SIZE = 10;

    public void uploadTables() {
        if (StringUtils.isBlank((CharSequence)this.httpConfig.getUploadProjectInfoAction())) {
            log.warn("uploadSynTBAction is null,will not upload tables");
            return;
        }
        if (MapUtils.isEmpty((Map)JdbConfigCache.TABLES_CACHE)) {
            log.warn("\u6ca1\u6709\u540c\u6b65\u6570\u636e\u8868\uff0c\u65e0\u9700\u4e0a\u4f20\u5230\u4e91\u7aef");
            return;
        }
        Collection tableDtoList = JdbConfigCache.TABLES_CACHE.values();
        ArrayList<TableInfo> subList = new ArrayList<TableInfo>();
        int i = 0;
        for (TableInfo table : tableDtoList) {
            subList.add(table);
            if (++i % 10 > 0) continue;
            this.uploadTables(subList);
            subList.clear();
        }
        this.uploadTables(subList);
    }

    private void uploadTables(List<TableInfo> subList) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authentication", this.httpConfig.getAuthentication());
        headers.put("action", this.httpConfig.getUploadProjectInfoAction());
        headers.put("config-type", "uploadDbTables");
        headers.put("rpcType", "http");
        headers.put("serialNo", "" + System.currentTimeMillis());
        try {
            HttpUtil.ResponseCus reponse = HttpUtil.doPostJsonEntire((String)this.httpConfig.getJanusUrl(), (String)JacksonUtil.getInstance().toJson(subList), headers, null);
            log.info("\u4e0a\u4f20\u8868[{}]\u4fe1\u606f\u5230\u4e91\u7aef\uff0c\u54cd\u5e94:{}", (Object)subList.stream().map(t -> t.getTableName()).collect(Collectors.joining(",")), (Object)reponse.getBody());
        }
        catch (Exception ex) {
            log.warn("\u540c\u6b65\u6570\u636e\u8868\u4fe1\u606f\u4e0a\u4f20\u5f02\u5e38", (Object)ErrorUtil.getStackMsg((Exception)ex));
        }
    }
}

