/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.dbsyn.init;

import com.xforceplus.janus.dbsyn.cache.DbSynCacheManager;
import com.xforceplus.janus.dbsyn.config.TbSynConfig;
import com.xforceplus.janus.dbsyn.handle.DataBatchHandler;
import com.xforceplus.janus.dbsyn.handle.DataHandlerFactory;
import com.xforceplus.janus.dbsyn.thread.DbTableSynThread;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class SynThreadLauncher {
    private static final Logger log = LoggerFactory.getLogger(SynThreadLauncher.class);
    @Autowired
    private DataHandlerFactory dataHandlerFactory;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public void launchSyn() {
        for (Map.Entry<String, TbSynConfig> entry : DbSynCacheManager.NEED_SYN_TABLES.entrySet()) {
            DataBatchHandler dataHandler = this.dataHandlerFactory.createHandler(entry.getValue());
            if (dataHandler == null) continue;
            DbTableSynThread dbTableSynRun = new DbTableSynThread(entry.getKey(), dataHandler);
            new Thread(dbTableSynRun).start();
        }
    }
}

