/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.dbsyn.task;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.bridgehead.core.config.TableColumnInfo;
import com.xforceplus.janus.bridgehead.core.config.TableInfo;
import com.xforceplus.janus.bridgehead.core.util.SpringContextUtils;
import com.xforceplus.janus.db.manager.cache.JdbConfigCache;
import com.xforceplus.janus.db.manager.common.TypesUtil;
import com.xforceplus.janus.dbsyn.cache.DbSynCacheManager;
import com.xforceplus.janus.dbsyn.enums.SynFlag;
import com.xforceplus.janus.dbsyn.enums.SynResult;
import com.xforceplus.janus.dbsyn.handle.DataBatchHandler;
import com.xforceplus.janus.dbsyn.handle.IDataExtHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterizedPreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class DbTableSynTask {
    private static final Logger log = LoggerFactory.getLogger(DbTableSynTask.class);
    private static final int BATCH_SIZE = 100;
    private JdbcTemplate jdbcTemplate;
    private DataBatchHandler dataHandler;
    private TableColumnInfo pkColumn;
    private StringBuilder updateSql;
    private StringBuilder querySql;
    private String tableName;
    private TableInfo table;
    public static Map<String, IDataExtHandler> dataExtHandlerMap = new HashMap<String, IDataExtHandler>();
    private StringBuilder subQuerySql;
    private TableInfo subTable;

    public DbTableSynTask(String tableName, DataBatchHandler dataHandler) {
        this.tableName = tableName;
        this.dataHandler = dataHandler;
        this.table = DbSynCacheManager.NEED_SYN_TABLES.get(this.tableName).getGenTable();
        this.pkColumn = this.table.getPK();
        if (this.pkColumn == null) {
            throw new NullPointerException(this.tableName + "\u4e3b\u952e\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)this.table.getSubTableName())) {
            this.subQuerySql = new StringBuilder("select * from").append(" ");
            this.subTable = (TableInfo)JdbConfigCache.TABLES_CACHE.get(this.table.getSubTableName());
            this.subQuerySql.append(this.table.getSubTableName()).append(" ").append("where").append(" ").append("janus_parent_id").append("=?");
        }
        this.initQuery();
        this.initUpdate();
    }

    private void initUpdate() {
        this.updateSql = new StringBuilder("update ");
        this.updateSql.append(this.tableName).append(" set ").append("janus_syn_flag").append("=").append(SynFlag.SYNFLAG_YES.getValue());
        this.updateSql.append(",").append("janus_modified_time").append("=?");
        this.updateSql.append(" where ").append(this.pkColumn.getColumnName()).append(" = ?");
    }

    private void initQuery() {
        this.querySql = new StringBuilder("select * from ");
        this.querySql.append(this.tableName).append(" where ").append("janus_syn_flag").append(" =").append(SynFlag.SYNFLAG_NO.getValue()).append(" limit ").append(this.dataHandler.getSynPageSize());
    }

    public SynResult doSynTask() {
        SynResult result = SynResult.FAILED;
        try {
            List<Map<String, Object>> dataList = this.queryNeedSynData();
            if (CollectionUtils.isEmpty(dataList)) {
                return SynResult.NO_DATA;
            }
            if (StringUtils.isNotBlank((CharSequence)this.table.getSubTableName())) {
                for (Map<String, Object> data : dataList) {
                    HashMap parentKeyParam = new HashMap();
                    List<Map<String, Object>> subs = this.querySubData(data.get(this.table.getPK().getJavaField()));
                    data.put(this.table.getSubClassFieldName(), subs);
                }
            }
            log.info("table {} begin syn", (Object)this.tableName);
            IDataExtHandler extHandler = dataExtHandlerMap.get(this.tableName);
            if (extHandler != null) {
                extHandler.wrapperHandler(dataList);
            }
            if (this.dataHandler.doHandler(dataList)) {
                this.tagSynFlag(dataList);
                log.info("table {} syn success:{}", (Object)this.tableName, (Object)JacksonUtil.getInstance().toJson(dataList));
                result = SynResult.SUCCESS;
            } else {
                List pks = dataList.stream().map(m -> m.get(this.pkColumn.getColumnName()).toString()).collect(Collectors.toList());
                log.error("\u8868[{}]\u540c\u6b65\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u6d89\u53capk:{}", (Object)this.tableName, pks);
                result = SynResult.FAILED;
            }
            return result;
        }
        catch (Throwable ex) {
            log.error("\u8868[{}]\u540c\u6b65\u6570\u636e\u5904\u7406\u5931\u8d25,{}", (Object)this.tableName, (Object)ex);
            return SynResult.FAILED;
        }
    }

    List<Map<String, Object>> queryNeedSynData() {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = (JdbcTemplate)SpringContextUtils.getBean(JdbcTemplate.class);
        }
        return this.jdbcTemplate.query(this.querySql.toString(), (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                for (TableColumnInfo col : DbTableSynTask.this.table.getColumns()) {
                    rowData.put(col.getJavaField(), rs.getObject(col.getColumnName()));
                }
                return rowData;
            }
        });
    }

    private List<Map<String, Object>> querySubData(Object parentId) {
        Object[] args = new Object[]{parentId};
        int[] types = new int[]{TypesUtil.getJdbcType((String)this.table.getPK().getJavaField())};
        return this.jdbcTemplate.query(this.subQuerySql.toString(), args, types, (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                for (TableColumnInfo col : DbTableSynTask.this.subTable.getColumns()) {
                    rowData.put(col.getJavaField(), rs.getObject(col.getColumnName()));
                }
                return rowData;
            }
        });
    }

    private void tagSynFlag(List<Map<String, Object>> dataList) {
        final String date = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        int[][] batchRows = this.jdbcTemplate.batchUpdate(this.updateSql.toString(), dataList, 100, (ParameterizedPreparedStatementSetter)new ParameterizedPreparedStatementSetter<Map<String, Object>>(){

            public void setValues(PreparedStatement ps, Map<String, Object> argument) throws SQLException {
                ps.setString(1, date);
                ps.setString(2, argument.get(DbTableSynTask.this.pkColumn.getColumnName()).toString());
            }
        });
    }
}

