/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.dbsyn.thread;

import com.xforceplus.janus.dbsyn.enums.SynResult;
import com.xforceplus.janus.dbsyn.handle.DataBatchHandler;
import com.xforceplus.janus.dbsyn.task.DbTableSynTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableSynThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DbTableSynThread.class);
    private DataBatchHandler dataBatchHandler;
    private String dbName;
    private boolean stop = false;

    public DbTableSynThread(String dbName, DataBatchHandler dataBatchHandler) {
        this.dbName = dbName;
        this.dataBatchHandler = dataBatchHandler;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.info("\u5f00\u542f\u8868[{}]\u5b9a\u65f6\u540c\u6b65\u529f\u80fd", (Object)this.dbName);
        DbTableSynTask synTask = new DbTableSynTask(this.dbName, this.dataBatchHandler);
        int sleepTick = 0;
        while (!this.stop) {
            SynResult result = synTask.doSynTask();
            if (result != SynResult.SUCCESS) {
                ++sleepTick;
                try {
                    Thread.sleep(1000 * sleepTick);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sleepTick <= 600) continue;
                sleepTick = 0;
                continue;
            }
            sleepTick = 0;
        }
        log.error(this.dbName + "\u5b9a\u65f6\u6570\u636e\u540c\u6b65\u4efb\u52a1\u7ed3\u675f");
    }
}

