package com.xforceplus.janus.framework.cmd;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.bridgehead.core.util.SpringContextUtils;
import com.xforceplus.janus.framework.event.AckTuple;
import com.xforceplus.janus.framework.event.ISealedMessageEventListener;
import com.xforceplus.janus.framework.event.SealedMessageEvent;
import com.xforceplus.janus.framework.event.SealedMessageEventListener;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.Collection;

import lombok.extern.slf4j.Slf4j;

/**
 * 集成平台命令消息接收
 *
 * @Author: xuchuanhou
 * @Date:2022/4/7下午5:41
 */
@Slf4j
@Component
@SealedMessageEventListener(requestName = "janusInternalCmd")
public class JanusCmdListener implements ISealedMessageEventListener {


    @Override
    public AckTuple<Boolean, String> onEvent(SealedMessageEvent sealedMessageEvent) {
       log.info(JacksonUtil.getInstance().toJson(sealedMessageEvent.getSealedMessage().getHeader()));

        String sourceType = sealedMessageEvent.getSealedMessage().getHeader().getOthers().get("sourceType");

        Collection<IJanusCmdHandler> cmdEventList = SpringContextUtils.getChildren(IJanusCmdHandler.class);
        if (CollectionUtils.isNotEmpty(cmdEventList)) {
            for (IJanusCmdHandler cmdHandler : cmdEventList) {
                if (cmdHandler.getSourceType().equals(sourceType)) {
                    cmdHandler.doHandler(sealedMessageEvent.getSealedMessage());
                }
            }
        }
        AckTuple<Boolean, String> ack =new AckTuple<>(true,"接收成功");
        return ack;
    }
}
