package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

import lombok.extern.slf4j.Slf4j;

@Configuration
@Slf4j
public class CusBeanConfig {

    @Autowired
    private Environment environment;

    @Bean
    public MCFactory getMcFactory(InternalListener messageListener) {
        String userId = environment.getProperty("tcp.client.userId");
        String host = environment.getProperty("tcp.server.ip");
        Integer port = environment.getProperty("tcp.server.port", Integer.class);
        MCFactory mcFactory = MCFactory.getInstance(userId, host, port);
        mcFactory.registerListener(messageListener);
        return mcFactory;
    }

}
