package com.xforceplus.janus.framework.record.cache;

import com.xforceplus.janus.bridgehead.core.monitor.JanusUploader;
import com.xforceplus.janus.bridgehead.core.monitor.param.MonitorParam;
import com.xforceplus.janus.bridgehead.core.util.SpringContextUtils;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.record.portal.RecordRetryHandler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

import lombok.extern.slf4j.Slf4j;

/**
 * 请求履历缓存
 *
 * @Date:2022/3/5下午3:19
 */
@Slf4j
@Component
public class AccessRecordCache {
    private static final int size = 500;
    private static final BlockingQueue<AccessRecord> ACCESS_RECORDS = new ArrayBlockingQueue(size);

    private static JanusUploader monitorUploader;

    private static long lastMonitorTime=0;

    @Autowired(required = false)
    private RecordRetryHandler recordRetryHandler;

    public  static void pushRecord(AccessRecord record) throws InterruptedException {
        if (record == null) {
            return;
        }
        boolean result = ACCESS_RECORDS.offer(record);
        if (!result) {
            log.error("accessrecord queue is full ,quantity:{}", size);

            if(lastMonitorTime==0 || System.currentTimeMillis()-lastMonitorTime>36000000){
               lastMonitorTime = System.currentTimeMillis();
               MonitorParam monitorParam =new MonitorParam();
               monitorParam.setDataType(MonitorParam.DATA_TYPE_HTTP);
               monitorParam.setMonitorType(MonitorParam.MONITOR_TYPE_SYS);
               monitorParam.setNoticeType(MonitorParam.NOTICE_TYPE_EMAIL);
               monitorParam.setNoticeContent("属地服务请求量过大，请求履历队列已满");
               monitorParam.setIndicator("serviceTimes");
                if(monitorUploader==null){
                    monitorUploader= SpringContextUtils.getBean(JanusUploader.class);
                }
               monitorUploader.uploadMonitor(monitorParam);
            }
        }
    }

    public static AccessRecord takeRecord() throws InterruptedException {
        return ACCESS_RECORDS.take();
    }

    private static final int TAKE_BATCH_SIZE = 9;


    /**
     * 阻塞批量获取
     *
     * @author xucuanhou
     * @date 2022/3/5
     */
    public static List<AccessRecord> takeBatch() throws InterruptedException {
        List<AccessRecord> ackMsgs = new ArrayList<>();
        AccessRecord accessRecord = ACCESS_RECORDS.take();
        ACCESS_RECORDS.drainTo(ackMsgs, TAKE_BATCH_SIZE);
        ackMsgs.add(accessRecord);
        return ackMsgs;
    }

}
